/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client.screen;

import com.epherical.serverbrowser.ServerQuery;
import com.epherical.serverbrowser.client.CommonClient;
import com.epherical.serverbrowser.client.Filter;
import com.epherical.serverbrowser.client.ServerPinger;
import com.epherical.serverbrowser.client.list.ServerBrowserList;
import com.epherical.serverbrowser.client.screen.FilterServerScreen;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_5244;
import net.minecraft.class_639;
import net.minecraft.class_641;
import net.minecraft.class_642;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ServerBrowserScreen
extends class_437 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ServerPinger pinger = new ServerPinger();
    protected ServerBrowserList list;
    private class_4185 joinButton;
    private class_4185 favoriteButton;
    private class_4185 next;
    private class_4185 prev;
    @Nullable
    private List<class_2561> toolTip;
    private class_2561 websiteStatus;
    private class_437 previousScreen;
    private int page = 1;

    public ServerBrowserScreen(class_437 previousScreen) {
        super(class_2561.method_30163((String)""));
        this.previousScreen = previousScreen;
    }

    protected void method_25426() {
        this.list = new ServerBrowserList(this, this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 64, 36);
        this.queryServers();
        this.list.queryServers();
        this.next = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43469((String)"serverbrowser.button.next_page", (Object[])new Object[]{this.page + 1}), button -> {
            if (this.list.getEntries().size() >= 20) {
                ++this.page;
                this.queryServers();
                this.list.queryServers();
                button.method_25355((class_2561)class_2561.method_43469((String)"serverbrowser.button.next_page", (Object[])new Object[]{this.page + 1}));
            }
        }).method_46434(this.field_22789 - 110, 12, 60, 20).method_46431());
        this.prev = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"serverbrowser.button.prev_page"), button -> {
            if (this.page <= 1) {
                this.page = 1;
            } else {
                --this.page;
                this.queryServers();
                this.list.queryServers();
            }
            this.next.method_25355((class_2561)class_2561.method_43469((String)"serverbrowser.button.next_page", (Object[])new Object[]{this.page + 1}));
        }).method_46434(this.field_22789 - 140, 12, 30, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"serverbrowser.button.register"), button -> this.field_22787.method_1507((class_437)new class_407(bl -> {
            if (bl) {
                class_156.method_668().method_670("https://minecraft.multiplayerservers.net");
            }
            this.field_22787.method_1507((class_437)this);
        }, "https://minecraft.multiplayerservers.net", true))).method_46434(this.field_22789 / 2 - 50, 3, 100, 20).method_46431());
        this.joinButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectServer.select"), button -> this.joinSelectedServer()).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 52, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"serverbrowser.button.filter"), button -> this.field_22787.method_1507((class_437)new FilterServerScreen(this))).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 52, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"serverbrowser.button.history"), button -> {}).method_46434(this.field_22789 / 2 + 54, this.field_22790 - 52, 100, 20).method_46431());
        this.favoriteButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"serverbrowser.button.favorite"), button -> {
            class_641 serverList = new class_641(this.field_22787);
            ServerBrowserList.Entry entry = (ServerBrowserList.Entry)this.list.method_25334();
            if (entry instanceof ServerBrowserList.BrowsedEntry) {
                ServerBrowserList.BrowsedEntry browsedEntry = (ServerBrowserList.BrowsedEntry)entry;
                class_642 serverData = browsedEntry.getServerData();
                serverList.method_2988(serverData, false);
                serverList.method_2987();
                this.field_22787.method_1507((class_437)new class_500((class_437)this));
            }
        }).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 70, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectServer.refresh"), button -> this.refreshServerList()).method_46434(this.field_22789 / 2 - 80, this.field_22790 - 28, 156, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.field_22787.method_1507((class_437)new class_500((class_437)new class_442()))).method_46434(this.field_22789 / 2 + 4 + 76, this.field_22790 - 28, 75, 20).method_46431());
        this.method_25429((class_364)this.list);
        this.onSelectedChange();
    }

    public void method_25394(class_332 poseStack, int mouseX, int mouseY, float partialTick) {
        this.toolTip = null;
        this.method_25420(poseStack);
        try {
            this.list.method_25394(poseStack, mouseX, mouseY, partialTick);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        if (this.toolTip != null) {
            poseStack.method_51434(this.field_22787.field_1772, this.toolTip, mouseX, mouseY);
        }
        this.next.field_22763 = false;
        this.prev.field_22763 = false;
        if (this.list.getEntries().size() >= 20) {
            this.next.field_22763 = true;
        }
        if (this.page > 1) {
            this.prev.field_22763 = true;
        }
        if (this.websiteStatus != null) {
            poseStack.method_27534(this.field_22787.field_1772, this.websiteStatus, this.field_22789 / 2, 40, 0xFFFFFF);
        }
    }

    public void queryServers() {
        this.websiteStatus = null;
        ServerQuery main = new ServerQuery(CommonClient.URL + "/api/v1/servers", builder -> {
            if (this.page > 1) {
                builder.addParameter("page", String.valueOf(this.page));
            }
            for (Filter filter : CommonClient.getInstance().getFilters()) {
                if (!filter.isActive()) continue;
                builder.addParameter("type", filter.getTagName());
            }
        }, throwable -> {
            this.websiteStatus = class_2561.method_43471((String)"serverbrowser.error.unreachable_website");
            return "";
        }, (s, throwable) -> {
            this.websiteStatus = null;
        });
        main.buildList(main.runQuery(), this.list, false);
        String packID = CommonClient.getInstance().getConfig().bisectPackID;
        if (packID.length() > 0 && this.page <= 1) {
            ServerQuery bisect = new ServerQuery("https://www.bisecthosting.com/api/v1/public_servers", builder -> builder.addParameter("id", packID), throwable -> {
                LOGGER.warn("Could not ping bisect's servers", throwable);
                return "";
            }, (s, throwable) -> {});
            bisect.buildList(bisect.runQuery(), this.list, true);
        }
        this.websiteStatus = class_2561.method_43471((String)"serverbrowser.error.unreachable_website");
    }

    public void setSelected(ServerBrowserList.Entry selected) {
        this.list.method_25313((class_350.class_351)selected);
        this.onSelectedChange();
    }

    protected void onSelectedChange() {
        this.joinButton.field_22763 = false;
        this.favoriteButton.field_22763 = false;
        ServerBrowserList.Entry entry = (ServerBrowserList.Entry)this.list.method_25334();
        if (entry instanceof ServerBrowserList.BrowsedEntry) {
            this.joinButton.field_22763 = true;
            this.favoriteButton.field_22763 = true;
        }
    }

    public void joinSelectedServer() {
        ServerBrowserList.Entry entry = (ServerBrowserList.Entry)this.list.method_25334();
        if (entry instanceof ServerBrowserList.BrowsedEntry) {
            this.join(((ServerBrowserList.BrowsedEntry)entry).getServerData());
        }
    }

    private void join(class_642 server) {
        class_412.method_36877((class_437)this, (class_310)this.field_22787, (class_639)class_639.method_2950((String)server.field_3761), (class_642)server, (boolean)false);
    }

    private void refreshServerList() {
        this.list.refreshServers();
    }

    public ServerPinger getPinger() {
        return this.pinger;
    }

    public void setToolTip(List<class_2561> toolTip) {
        this.toolTip = toolTip;
    }
}

