/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client.list;

import com.epherical.serverbrowser.client.CommonClient;
import com.epherical.serverbrowser.client.screen.ServerBrowserScreen;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_124;
import net.minecraft.class_140;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_642;
import net.minecraft.class_757;
import net.minecraft.class_8573;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ServerBrowserList
extends class_4280<Entry> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("ServerBrowser Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(LOGGER)).build());
    private static final class_2960 ICON_MISSING = new class_2960("textures/misc/unknown_server.png");
    private static final class_2960 ICON_OVERLAY_LOCATION = new class_2960("textures/gui/server_selection.png");
    private static final class_2561 CANT_RESOLVE_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_resolve").method_27692(class_124.field_1079);
    private static final class_2561 CANT_CONNECT_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_connect").method_27692(class_124.field_1079);
    private static final class_2561 INCOMPATIBLE_TOOLTIP = class_2561.method_43471((String)"multiplayer.status.incompatible");
    private static final class_2561 NO_CONNECTION_TOOLTIP = class_2561.method_43471((String)"multiplayer.status.no_connection");
    private static final class_2561 PINGING_TOOLTIP = class_2561.method_43471((String)"multiplayer.status.pinging");
    static final class_2960 GUI_ICONS_LOCATION = new class_2960("textures/gui/icons.png");
    private final ServerBrowserScreen screen;
    private final List<BrowsedEntry> entries = new ArrayList<BrowsedEntry>();

    public ServerBrowserList(ServerBrowserScreen screen, class_310 minecraft, int i, int j, int k, int l, int m) {
        super(minecraft, i, j, k, l, m);
        this.screen = screen;
    }

    public void refreshServers() {
        for (BrowsedEntry entry : this.entries) {
            entry.getServerData().field_3754 = false;
        }
    }

    public List<BrowsedEntry> getEntries() {
        return this.entries;
    }

    public void queryServers() {
        this.entries.clear();
        this.method_25339();
    }

    public void addEntries(JsonElement jsonElement, boolean toTop) {
        JsonArray array = new JsonArray();
        array = jsonElement.getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject object = (JsonObject)element;
            BrowsedEntry browsedEntry = toTop ? new BrowsedEntry(this.screen, object.get("name").getAsString(), object.get("ip").getAsString(), object.get("port").getAsInt(), this.field_22740) : new BrowsedEntry(this.screen, object, this.field_22740);
            if (!browsedEntry.isValid()) continue;
            this.entries.add(browsedEntry);
            if (toTop) {
                this.method_44399((class_350.class_351)browsedEntry);
                continue;
            }
            this.method_25321((class_350.class_351)browsedEntry);
        }
    }

    protected int method_25329() {
        return super.method_25329() + 30;
    }

    public int method_25322() {
        return super.method_25322() + 85;
    }

    public class BrowsedEntry
    extends Entry {
        private final ServerBrowserScreen screen;
        private final String serverName;
        private final String ipAddress;
        private final int port;
        private final class_2561 description;
        private final List<String> tags;
        private final int rank;
        private final int bgColor;
        @Nullable
        private byte[] lastIconB64;
        private class_8573 icon;
        private final class_310 minecraft;
        private class_642 serverData;
        private long lastClickTime;
        private boolean valid = true;
        private AtomicBoolean validServer = new AtomicBoolean(true);

        public BrowsedEntry(ServerBrowserScreen screen, String serverName, String ipAddress, int port, class_310 minecraft) {
            this.screen = screen;
            int strLen = serverName.length();
            this.serverName = strLen <= 45 ? serverName : serverName.substring(0, 45);
            this.ipAddress = ipAddress;
            this.port = port;
            this.description = class_2561.method_43470((String)"Unknown server from 3rd party service.");
            this.rank = 0;
            this.bgColor = 2188223;
            this.minecraft = minecraft;
            this.tags = new ArrayList<String>();
            this.assignCommonData();
        }

        public BrowsedEntry(ServerBrowserScreen screen, JsonObject object, class_310 minecraft) {
            this.screen = screen;
            String serverName = object.get("serverName").getAsString();
            int strLen = serverName.length();
            this.serverName = strLen <= 40 ? serverName : serverName.substring(0, 40);
            this.ipAddress = object.get("ipAddress").getAsString();
            this.port = object.get("port").getAsInt();
            String address = this.ipAddress.toLowerCase(Locale.ROOT);
            if (CommonClient.getInstance().getConfig().blacklistedServers.contains(address)) {
                this.valid = false;
            }
            this.description = class_2561.method_43470((String)object.get("description").getAsString());
            ArrayList<String> tags = new ArrayList<String>();
            JsonArray array = object.getAsJsonArray("tags");
            for (JsonElement tag : array) {
                tags.add(tag.getAsString());
            }
            this.tags = tags;
            this.rank = object.get("rank").getAsInt();
            this.bgColor = object.get("backgroundColor").getAsInt();
            this.minecraft = minecraft;
            this.assignCommonData();
        }

        private void assignCommonData() {
            Object ip = this.port != 0 ? this.ipAddress + ":" + this.port : this.ipAddress;
            this.icon = class_8573.method_52202((class_1060)this.minecraft.method_1531(), (String)ip);
            this.serverData = new class_642(this.serverName, (String)ip, false);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            double d = mouseX - (double)ServerBrowserList.this.method_25342();
            if (d <= 32.0 && d < 32.0 && d > 16.0 && this.canJoin()) {
                this.screen.setSelected(this);
                this.screen.joinSelectedServer();
                return true;
            }
            this.screen.setSelected(this);
            if (class_156.method_658() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
            }
            this.lastClickTime = class_156.method_658();
            return false;
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)"howdy partner");
        }

        public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            if (!this.serverData.field_3754) {
                this.serverData.field_3754 = true;
                this.serverData.field_3758 = -2L;
                this.serverData.field_3757 = class_5244.field_39003;
                this.serverData.field_3753 = class_5244.field_39003;
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().pingServer(this.serverData, () -> this.minecraft.execute(() -> {}), this.validServer);
                    }
                    catch (UnknownHostException var2) {
                        this.serverData.field_3758 = -1L;
                        this.serverData.field_3757 = CANT_RESOLVE_TEXT;
                        this.validServer.set(false);
                    }
                    catch (Exception var3) {
                        this.serverData.field_3758 = -1L;
                        this.serverData.field_3757 = CANT_CONNECT_TEXT;
                        this.validServer.set(false);
                    }
                });
            }
            if (this.validServer.get()) {
                List list2;
                class_2561 component2;
                int latency;
                boolean bl = this.serverData.field_3756 != class_155.method_16673().method_48020();
                graphics.method_25303(this.minecraft.field_1772, this.serverData.field_3752, left + 32 + 3, top + 1, 0xFFFFFF);
                List list = this.minecraft.field_1772.method_1728((class_5348)this.serverData.field_3757, width - 32 - 2);
                for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                    graphics.method_35720(this.minecraft.field_1772, (class_5481)list.get(i), left + 32 + 3, top + 12 + 9 * i, 0x808080);
                }
                class_2561 component = bl ? this.serverData.field_3760.method_27661().method_27692(class_124.field_1061) : this.serverData.field_3753;
                int textWidth = this.minecraft.field_1772.method_27525((class_5348)component);
                graphics.method_27535(this.minecraft.field_1772, component, left + width - textWidth - 15 - 2, top + 1, 0x808080);
                int k = 0;
                if (bl) {
                    latency = 5;
                    component2 = INCOMPATIBLE_TOOLTIP;
                    list2 = this.serverData.field_3762;
                } else if (this.serverData.field_3754 && this.serverData.field_3758 != -2L) {
                    latency = this.serverData.field_3758 < 0L ? 5 : (this.serverData.field_3758 < 150L ? 0 : (this.serverData.field_3758 < 300L ? 1 : (this.serverData.field_3758 < 600L ? 2 : (this.serverData.field_3758 < 1000L ? 3 : 4))));
                    if (this.serverData.field_3758 < 0L) {
                        component2 = NO_CONNECTION_TOOLTIP;
                        list2 = Collections.emptyList();
                    } else {
                        component2 = class_2561.method_43469((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.field_3758});
                        list2 = this.serverData.field_3762;
                    }
                } else {
                    k = 1;
                    latency = (int)(class_156.method_658() / 100L + (long)index * 2L & 7L);
                    if (latency > 4) {
                        latency = 8 - latency;
                    }
                    component2 = PINGING_TOOLTIP;
                    list2 = Collections.emptyList();
                }
                graphics.method_25290(GUI_ICONS_LOCATION, left + width - 15, top, (float)(k * 10), (float)(176 + latency * 8), 10, 8, 256, 256);
                byte[] abyte = this.serverData.method_49306();
                if (!Arrays.equals(abyte, this.lastIconB64)) {
                    if (this.uploadServerIcon(abyte)) {
                        this.lastIconB64 = abyte;
                    } else {
                        this.serverData.method_49305(null);
                    }
                }
                this.drawIcon(graphics, left, top, this.icon.method_52201());
                int m = mouseX - left;
                int n = mouseY - top;
                if (((Boolean)this.minecraft.field_1690.method_42446().method_41753()).booleanValue() || isMouseOver) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)ICON_OVERLAY_LOCATION);
                    graphics.method_25294(left, top, left + 32, top + 32, -1601138544);
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    int o = mouseX - left;
                    if (this.canJoin()) {
                        int currentLength = 0;
                        int maxLength = 150;
                        ArrayList<String> condensedTags = new ArrayList<String>();
                        condensedTags.add("Tags");
                        StringBuilder condenser = new StringBuilder();
                        this.tags.sort(String::compareTo);
                        for (String tag : this.tags) {
                            if (currentLength >= maxLength) {
                                currentLength = 0;
                                condensedTags.add(condenser.append(",").toString());
                                condenser = new StringBuilder();
                            } else if (condenser.length() == 0) {
                                condenser.append(tag);
                            } else {
                                condenser.append(", ").append(tag);
                            }
                            currentLength += this.minecraft.field_1772.method_1727(tag);
                        }
                        condensedTags.add(condenser.toString());
                        List<class_2561> components = condensedTags.stream().map(class_2561::method_43470).collect(Collectors.toList());
                        this.screen.setToolTip(components);
                    }
                }
                if (m >= width - 15 && m <= width - 5 && n >= 0 && n <= 8) {
                    this.screen.setToolTip(Collections.singletonList(component2));
                } else if (m >= width - textWidth - 15 - 2 && m <= width - 15 - 2 && n >= 0 && n <= 8) {
                    this.screen.setToolTip(list2);
                }
            } else {
                ServerBrowserList.this.method_25330((class_350.class_351)this);
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        protected void drawIcon(class_332 $$0, int $$1, int $$2, class_2960 $$3) {
            RenderSystem.enableBlend();
            $$0.method_25290($$3, $$1, $$2, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
        }

        private boolean uploadServerIcon(byte[] bytes) {
            if (bytes == null) {
                this.icon.method_52198();
            } else {
                try {
                    this.icon.method_52199(class_1011.method_49277((byte[])bytes));
                }
                catch (Throwable var3) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.field_3752, this.serverData.field_3761, var3});
                    return false;
                }
            }
            return true;
        }

        private boolean canJoin() {
            return true;
        }

        public class_642 getServerData() {
            return this.serverData;
        }
    }

    public static abstract class Entry
    extends class_4280.class_4281<Entry> {
    }
}

