/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import dev.wuffs.bcc.CommonClass;
import dev.wuffs.bcc.contract.ServerDataExtension;
import dev.wuffs.bcc.data.BetterStatus;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2889;
import net.minecraft.class_2921;
import net.minecraft.class_2923;
import net.minecraft.class_2924;
import net.minecraft.class_2926;
import net.minecraft.class_2935;
import net.minecraft.class_2937;
import net.minecraft.class_412;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6368;
import net.minecraft.class_6370;
import net.minecraft.class_639;
import net.minecraft.class_642;
import org.slf4j.Logger;

public class ServerPinger {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2561 CANT_CONNECT_MESSAGE = class_2561.method_43471((String)"multiplayer.status.cannot_connect").method_27694(style -> style.method_36139(-65536));
    private final List<class_2535> connections = Collections.synchronizedList(Lists.newArrayList());

    public void pingServer(final class_642 data, final Runnable runnable, final AtomicBoolean atomicBoolean) throws UnknownHostException {
        class_639 serverAddress = class_639.method_2950((String)data.field_3761);
        Optional<InetSocketAddress> optionalINet = class_6370.field_33745.method_36907(serverAddress).map(class_6368::method_36902);
        if (!optionalINet.isPresent()) {
            atomicBoolean.set(false);
            this.onPingFailed(class_412.field_33736, data);
        } else {
            InetSocketAddress socketAddress = optionalINet.get();
            final class_2535 connection = class_2535.method_10753((InetSocketAddress)socketAddress, (boolean)false);
            this.connections.add(connection);
            data.field_3757 = class_2561.method_43471((String)"multiplayer.status.pinging");
            data.field_3758 = -1L;
            data.field_3762 = Collections.emptyList();
            connection.method_10763((class_2547)new class_2921(){
                private boolean success;
                private boolean receivedPing;
                private long pingStart;

                public void method_12667(class_2924 responsePacket) {
                    if (this.receivedPing) {
                        connection.method_10747((class_2561)class_2561.method_43471((String)"multiplayer.status.unrequested"));
                        atomicBoolean.set(false);
                    } else {
                        this.receivedPing = true;
                        class_2926 serverStatus = responsePacket.comp_1272();
                        data.field_3757 = serverStatus.comp_1273();
                        BetterStatus betterData = ((ServerDataExtension)responsePacket.comp_1272()).getBetterData();
                        if (betterData == null || !CommonClass.comparePingData((BetterStatus)betterData)) {
                            atomicBoolean.set(false);
                        }
                        ((ServerDataExtension)data).setBetterData(betterData);
                        serverStatus.comp_1275().ifPresentOrElse(version -> {
                            data2.field_3760 = class_2561.method_43470((String)version.comp_1282());
                            data2.field_3756 = version.comp_1283();
                        }, () -> {
                            data2.field_3760 = class_2561.method_43471((String)"multiplayer.status.old");
                            data2.field_3756 = 0;
                        });
                        serverStatus.comp_1274().ifPresentOrElse(players -> {
                            data2.field_3753 = ServerPinger.formatPlayerCount(players.comp_1280(), players.comp_1279());
                            data2.field_41861 = players;
                            if (!players.comp_1281().isEmpty()) {
                                ArrayList<class_5250> messages = new ArrayList<class_5250>(players.comp_1281().size());
                                for (GameProfile profile : players.comp_1281()) {
                                    messages.add(class_2561.method_43470((String)profile.getName()));
                                }
                                if (players.comp_1281().size() < players.comp_1280()) {
                                    messages.add(class_2561.method_43469((String)"multiplayer.status.and_more", (Object[])new Object[]{players.comp_1280() - players.comp_1281().size()}));
                                }
                                data2.field_3762 = messages;
                            } else {
                                data2.field_3762 = List.of();
                            }
                        }, () -> {
                            data2.field_3753 = class_2561.method_43471((String)"multiplayer.status.unknown").method_27692(class_124.field_1063);
                        });
                        serverStatus.comp_1276().ifPresent($$2 -> {
                            if (!Arrays.equals($$2.comp_1278(), data.method_49306())) {
                                data.method_49305($$2.comp_1278());
                                runnable.run();
                            }
                        });
                        this.pingStart = class_156.method_658();
                        connection.method_10743((class_2596)new class_2935(this.pingStart));
                        this.success = true;
                    }
                }

                public void method_12666(class_2923 response) {
                    long start = this.pingStart;
                    long current = class_156.method_658();
                    data.field_3758 = current - start;
                    connection.method_10747((class_2561)class_2561.method_43471((String)"multiplayer.status.finished"));
                }

                public void method_10839(class_2561 message) {
                    if (!this.success) {
                        atomicBoolean.set(false);
                        ServerPinger.this.onPingFailed(message, data);
                    }
                }

                public boolean method_48106() {
                    atomicBoolean.set(connection.method_10758());
                    return connection.method_10758();
                }
            });
            try {
                System.out.print("");
                connection.method_10743((class_2596)new class_2889(serverAddress.method_2952(), serverAddress.method_2954(), class_2539.field_20592));
                connection.method_10743((class_2596)new class_2937());
            }
            catch (Throwable error) {
                atomicBoolean.set(false);
                LOGGER.error("Failed to ping server {}", (Object)data, (Object)error);
            }
        }
    }

    static class_2561 formatPlayerCount(int $$0, int $$1) {
        return class_2561.method_43470((String)Integer.toString($$0)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1063)).method_27693(Integer.toString($$1)).method_27692(class_124.field_1080);
    }

    public void onPingFailed(class_2561 message, class_642 server) {
        LOGGER.error("Can't ping {}: {}", (Object)server.field_3761, (Object)message.getString());
        server.field_3757 = CANT_CONNECT_MESSAGE;
        server.field_3753 = class_5244.field_39003;
    }
}

