/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.storage_blocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import svenhjol.charm.feature.storage_blocks.IStorageBlockFeature;
import svenhjol.charm.feature.storage_blocks.StorageBlocks;
import svenhjol.charm.feature.storage_blocks.ender_pearls.EnderPearlsClient;
import svenhjol.charm.feature.storage_blocks.gunpowder.GunpowderClient;
import svenhjol.charm.feature.storage_blocks.sugar.SugarClient;
import svenhjol.charmony.client.ClientFeature;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.iface.IClientRegistry;
import svenhjol.charmony.iface.ILog;

public class StorageBlocksClient
extends ClientFeature {
    static Map<Class<? extends IStorageBlockFeature<IClientRegistry>>, IStorageBlockFeature<IClientRegistry>> LOADED_STORAGE_BLOCKS = new HashMap<Class<? extends IStorageBlockFeature<IClientRegistry>>, IStorageBlockFeature<IClientRegistry>>();

    public Class<? extends CommonFeature> commonFeature() {
        return StorageBlocks.class;
    }

    public void register() {
        IClientRegistry registry = this.mod().registry();
        List<Class<SugarClient>> features = List.of(EnderPearlsClient.class, GunpowderClient.class, SugarClient.class);
        for (Class<SugarClient> feature : features) {
            StorageBlocksClient.register(registry, feature);
        }
    }

    public void runWhenEnabled() {
        LOADED_STORAGE_BLOCKS.values().forEach(block -> {
            if (block.isEnabled()) {
                block.runWhenEnabled();
            } else {
                block.runWhenDisabled();
            }
        });
    }

    public void runWhenDisabled() {
        LOADED_STORAGE_BLOCKS.values().forEach(IStorageBlockFeature::runWhenDisabled);
    }

    public static void register(IClientRegistry registry, Class<? extends IStorageBlockFeature<IClientRegistry>> feature) {
        ILog log = registry.getLog();
        try {
            IStorageBlockFeature<IClientRegistry> instance = feature.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.preRegister(registry);
            instance.register();
            LOADED_STORAGE_BLOCKS.put(feature, instance);
        }
        catch (Exception e) {
            log.warn(StorageBlocksClient.class, "Error loading client storage block " + String.valueOf(feature) + ", skipping: " + e.getMessage(), new Object[0]);
        }
    }
}

