/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.storage_blocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import svenhjol.charm.feature.storage_blocks.IStorageBlockFeature;
import svenhjol.charm.feature.storage_blocks.StorageBlockDataProviders;
import svenhjol.charm.feature.storage_blocks.ender_pearls.EnderPearls;
import svenhjol.charm.feature.storage_blocks.gunpowder.Gunpowder;
import svenhjol.charm.feature.storage_blocks.sugar.Sugar;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.api.CharmonyApi;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.iface.ICommonRegistry;
import svenhjol.charmony.iface.ILog;

public class StorageBlocks
extends CommonFeature {
    static final Map<Class<? extends IStorageBlockFeature>, IStorageBlockFeature> LOADED_STORAGE_BLOCKS = new HashMap<Class<? extends IStorageBlockFeature>, IStorageBlockFeature>();
    @Configurable(name="Ender pearls", description="If true, ender pearl blocks will be enabled.")
    public static boolean enderPearlsEnabled = true;
    @Configurable(name="Gunpowder", description="If true, gunpowder blocks will be enabled.")
    public static boolean gunpowderEnabled = true;
    @Configurable(name="Sugar", description="If true, sugar blocks will be enabled.")
    public static boolean sugarEnabled = true;
    @Configurable(name="Ender pearl block converts silverfish", description="If true, ender pearl blocks will convert silverfish to endermites.")
    public static boolean enderPearlBlocksConvertSilverfish = true;

    public String description() {
        return "More item blocks.";
    }

    public static Optional<IStorageBlockFeature> getStorageBlock(Class<? extends IStorageBlockFeature> clazz) {
        return Optional.ofNullable(LOADED_STORAGE_BLOCKS.get(clazz));
    }

    public void register() {
        ICommonRegistry registry = this.mod().registry();
        List<Class<Sugar>> features = List.of(EnderPearls.class, Gunpowder.class, Sugar.class);
        for (Class<Sugar> feature : features) {
            StorageBlocks.register(registry, feature);
        }
        CharmonyApi.registerProvider((Object)new StorageBlockDataProviders());
    }

    public void runWhenEnabled() {
        LOADED_STORAGE_BLOCKS.values().forEach(block -> {
            if (block.isEnabled()) {
                block.runWhenEnabled();
            } else {
                block.runWhenDisabled();
            }
        });
    }

    public static void register(ICommonRegistry registry, Class<? extends IStorageBlockFeature<ICommonRegistry>> feature) {
        ILog log = registry.getLog();
        try {
            IStorageBlockFeature<ICommonRegistry> instance = feature.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.preRegister(registry);
            instance.register();
            LOADED_STORAGE_BLOCKS.put(feature, instance);
        }
        catch (Exception e) {
            log.warn(StorageBlocks.class, "Error loading storage block " + String.valueOf(feature) + ", skipping: " + e.getMessage(), new Object[0]);
        }
    }

    public boolean isEnderPearlsEnabled() {
        return this.isEnabled() && enderPearlsEnabled;
    }

    public boolean isGunpowderEnabled() {
        return this.isEnabled() && gunpowderEnabled;
    }

    public boolean isSugarEnabled() {
        return this.isEnabled() && sugarEnabled;
    }

    public void runWhenDisabled() {
        LOADED_STORAGE_BLOCKS.values().forEach(IStorageBlockFeature::runWhenDisabled);
    }
}

