/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.nearby_workstations;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import svenhjol.charm.feature.nearby_workstations.NearbyWorkstations;
import svenhjol.charm.feature.nearby_workstations.NearbyWorkstationsClient;
import svenhjol.charmony.annotation.Packet;
import svenhjol.charmony.base.Mods;
import svenhjol.charmony.enums.PacketDirection;
import svenhjol.charmony.iface.ICommonRegistry;
import svenhjol.charmony.iface.IPacketRequest;

public class NearbyWorkstationsNetwork {
    public static void register() {
        ICommonRegistry registry = Mods.common((String)"charm").registry();
        registry.packet((IPacketRequest)new OpenWorkstationSelector(), () -> NearbyWorkstations::handleOpenedSelector);
        registry.packet((IPacketRequest)new OpenSpecificWorkstation(), () -> NearbyWorkstations::handleOpenedSpecificWorkstation);
        registry.packet((IPacketRequest)new OpenWorkstationSelectorScreen(), () -> NearbyWorkstationsClient::handleOpenedSelectorScreen);
    }

    @Packet(id="charm:open_workstation_selector", direction=PacketDirection.CLIENT_TO_SERVER, description="An empty packet sent from the client to instruct the server to open the workstation selector.")
    public static class OpenWorkstationSelector
    implements IPacketRequest {
        private OpenWorkstationSelector() {
        }

        public static void send() {
            Mods.client((String)"charm").network().send((IPacketRequest)new OpenWorkstationSelector());
        }
    }

    @Packet(id="charm:open_specific_workstation", direction=PacketDirection.CLIENT_TO_SERVER, description="Workstation block sent from client to instruct the server to open a specific container.")
    public static class OpenSpecificWorkstation
    implements IPacketRequest {
        private class_2248 workstation;

        private OpenSpecificWorkstation() {
        }

        public static void send(class_2248 workstation) {
            OpenSpecificWorkstation message = new OpenSpecificWorkstation();
            message.workstation = workstation;
            Mods.client((String)"charm").network().send((IPacketRequest)message);
        }

        public void encode(class_2540 buf) {
            class_2960 key = class_7923.field_41175.method_10221((Object)this.workstation);
            buf.method_10814(key.toString());
        }

        public void decode(class_2540 buf) {
            String key = buf.method_19772();
            this.workstation = (class_2248)class_7923.field_41175.method_10223(new class_2960(key));
        }

        public class_2248 getWorkstation() {
            return this.workstation;
        }
    }

    @Packet(id="charm:open_workstation_selector_screen", direction=PacketDirection.SERVER_TO_CLIENT, description="List of workstation blocks sent from the server to be shown on the workstation selection screen.")
    public static class OpenWorkstationSelectorScreen
    implements IPacketRequest {
        private List<class_2248> workstations = new LinkedList<class_2248>();

        private OpenWorkstationSelectorScreen() {
        }

        public static void send(class_1657 player, List<class_2248> workstations) {
            OpenWorkstationSelectorScreen message = new OpenWorkstationSelectorScreen();
            message.workstations = workstations;
            Mods.common((String)"charm").network().send((IPacketRequest)message, player);
        }

        public void encode(class_2540 buf) {
            class_2499 blockList = new class_2499();
            for (class_2248 workstation : this.workstations) {
                class_2960 key = class_7923.field_41175.method_10221((Object)workstation);
                blockList.add((Object)class_2519.method_23256((String)key.toString()));
            }
            class_2487 nbt = new class_2487();
            nbt.method_10566("workstations", (class_2520)blockList);
            buf.method_10794(nbt);
        }

        public void decode(class_2540 buf) {
            this.workstations.clear();
            class_2487 nbt = buf.method_10798();
            if (nbt != null) {
                class_2499 blockList = nbt.method_10554("workstations", 8);
                for (class_2520 blockTag : blockList) {
                    class_2248 workstation = (class_2248)class_7923.field_41175.method_10223(new class_2960(blockTag.method_10714()));
                    this.workstations.add(workstation);
                }
            }
        }

        public List<class_2248> getWorkstations() {
            return this.workstations;
        }
    }
}

