/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.make_suspicious_blocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2591;
import net.minecraft.class_2665;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_8174;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.helper.PlayerHelper;

public class MakeSuspiciousBlocks
extends CommonFeature {
    static final Map<class_2248, class_2248> SUSPICIOUS_BLOCK_CONVERSIONS = new HashMap<class_2248, class_2248>();
    static Supplier<class_3414> addItemSound;

    public String description() {
        return "Use a piston to push an item into sand or gravel, making it suspicious.";
    }

    public void register() {
        addItemSound = this.mod().registry().soundEvent("make_suspicious_block");
        MakeSuspiciousBlocks.registerSuspiciousBlockConversion(class_2246.field_10102, class_2246.field_42728);
        MakeSuspiciousBlocks.registerSuspiciousBlockConversion(class_2246.field_10255, class_2246.field_43227);
    }

    public static void registerSuspiciousBlockConversion(class_2248 normal, class_2248 suspicious) {
        SUSPICIOUS_BLOCK_CONVERSIONS.put(normal, suspicious);
    }

    public static void checkAndConvert(class_1937 level, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2665.field_10927);
        class_2338 d1 = pos.method_10079(direction, 1);
        class_2338 d2 = pos.method_10079(direction, 2);
        class_2680 target = level.method_8320(d2);
        class_5819 random = level.method_8409();
        if (!SUSPICIOUS_BLOCK_CONVERSIONS.containsKey(target.method_26204())) {
            return;
        }
        List itemEntities = level.method_18467(class_1542.class, new class_238(d1));
        if (itemEntities.isEmpty()) {
            return;
        }
        class_1542 itemEntity = (class_1542)itemEntities.get(random.method_43048(itemEntities.size()));
        class_1799 stack = itemEntity.method_6983();
        boolean result = MakeSuspiciousBlocks.makeSuspiciousBlock(level, d2, stack);
        if (result) {
            itemEntity.method_5768();
            if (!level.field_9236) {
                MakeSuspiciousBlocks.triggerMadeSuspiciousBlock((class_3218)level, pos);
            }
        }
    }

    static boolean makeSuspiciousBlock(class_1937 level, class_2338 pos, class_1799 stack) {
        class_2680 targetState = level.method_8320(pos);
        class_2248 targetBlock = targetState.method_26204();
        class_2248 suspiciousBlock = SUSPICIOUS_BLOCK_CONVERSIONS.getOrDefault(targetBlock, null);
        if (suspiciousBlock == null) {
            return false;
        }
        level.method_8501(pos, suspiciousBlock.method_9564());
        Optional opt = level.method_35230(pos, class_2591.field_42780);
        if (opt.isPresent()) {
            class_8174 brushable = (class_8174)opt.get();
            brushable.field_42814 = null;
            brushable.field_42812 = stack.method_7972();
            if (level.field_9236) {
                class_5819 random = level.method_8409();
                for (int i = 0; i < 18; ++i) {
                    level.method_8406((class_2394)class_2398.field_22247, (double)pos.method_10263() + random.method_43058() * 1.25, (double)pos.method_10264() + 1.08, (double)pos.method_10260() + random.method_43058() * 1.25, 0.0, 0.0, 0.0);
                }
            }
            level.method_8396(null, pos, addItemSound.get(), class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static void triggerMadeSuspiciousBlock(class_3218 level, class_2338 pos) {
        PlayerHelper.getPlayersInRange((class_1937)level, (class_2338)pos, (double)8.0).forEach(player -> Advancements.trigger((class_2960)new class_2960("charm", "made_suspicious_block"), (class_1657)player));
    }
}

