/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.lumberjacks;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3852;
import svenhjol.charm.CharmTags;
import svenhjol.charm.feature.lumberjacks.LumberjackTradeOffers;
import svenhjol.charm.feature.woodcutters.Woodcutters;
import svenhjol.charmony.CharmonyTags;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.feature.variant_wood.VariantWood;
import svenhjol.charmony.helper.GenericTradeOffers;
import svenhjol.charmony.iface.ICommonMod;
import svenhjol.charmony.iface.ICommonRegistry;

public class Lumberjacks
extends CommonFeature {
    private static final String ID = "lumberjack";
    public static Supplier<class_3852> profession;
    public static Supplier<class_3414> workSound;

    public String description() {
        return "Lumberjacks are villagers that trade wooden items. Their job site is the woodcutter.";
    }

    public int priority() {
        return -1;
    }

    public List<BooleanSupplier> checks() {
        return List.of(() -> this.mod().loader().isEnabled(Woodcutters.class));
    }

    public void register() {
        ICommonRegistry registry = this.mod().registry();
        workSound = registry.soundEvent(ID);
        profession = registry.villagerProfession(ID, "woodcutter", List.of(Woodcutters.block), workSound);
        registry.villagerGift(ID);
        if (this.isEnabled()) {
            this.addTrades();
        }
    }

    private void addTrades() {
        ICommonMod charm = this.mod();
        ICommonRegistry registry = charm.registry();
        boolean useVariantBarrels = VariantWood.variantBarrels;
        boolean usevariantBookshelves = VariantWood.variantBookshelves;
        boolean useVariantLadders = VariantWood.variantLadders;
        registry.villagerTrade(profession, 1, () -> new GenericTradeOffers.EmeraldsForTag(CharmTags.OVERWORLD_STRIPPED_LOGS, 8, 1, 1, 0, 2, 20));
        registry.villagerTrade(profession, 1, () -> new GenericTradeOffers.EmeraldsForTag(class_3481.field_39030, 8, 1, 1, 0, 2, 20));
        registry.villagerTrade(profession, 3, () -> new LumberjackTradeOffers.SaplingsForEmeralds(List.of(class_1802.field_17535, class_1802.field_17537, class_1802.field_17536), 1, 0, 2, 20));
        if (useVariantLadders) {
            registry.villagerTrade(profession, 1, () -> new GenericTradeOffers.TagForEmeralds(CharmonyTags.LADDERS, 1, 1, 2, 20));
        } else {
            registry.villagerTrade(profession, 1, () -> new GenericTradeOffers.ItemsForEmeralds((class_1935)class_1802.field_8121, 1, 1, 2, 20));
        }
        registry.villagerTrade(profession, 2, () -> new GenericTradeOffers.EmeraldsForItems((class_1935)class_1802.field_8606, 23, 2, 1, 0, 5, 20));
        registry.villagerTrade(profession, 2, () -> new GenericTradeOffers.TagForEmeralds(class_3481.field_16443, 3, 2, 1, 0, 7, 20));
        registry.villagerTrade(profession, 2, () -> new GenericTradeOffers.TagForEmeralds(class_3481.field_17619, 2, 1, 1, 0, 6, 20));
        registry.villagerTrade(profession, 2, () -> new GenericTradeOffers.TagForEmeralds(class_3481.field_25147, 2, 1, 1, 0, 6, 20));
        registry.villagerTrade(profession, 3, () -> new GenericTradeOffers.EmeraldsForTag(class_3481.field_21956, 7, 1, 1, 0, 10, 20));
        registry.villagerTrade(profession, 3, () -> new GenericTradeOffers.EmeraldsForTag(class_3481.field_21955, 7, 1, 1, 0, 10, 20));
        registry.villagerTrade(profession, 3, () -> new LumberjackTradeOffers.SaplingsForEmeralds(List.of(class_1802.field_17539, class_1802.field_17540), 2, 1, 10, 20));
        registry.villagerTrade(profession, 3, () -> new LumberjackTradeOffers.BarkForLogs(10, 12, 10, 10));
        registry.villagerTrade(profession, 3, () -> new GenericTradeOffers.TagForEmeralds(class_3481.field_15494, 2, 1, 1, 0, 10, 20));
        if (useVariantBarrels) {
            registry.villagerTrade(profession, 4, () -> new GenericTradeOffers.TagForEmeralds(CharmonyTags.BARRELS, 4, 1, 1, 0, 15, 20));
        } else {
            registry.villagerTrade(profession, 4, () -> new GenericTradeOffers.ItemsForEmeralds((class_1935)class_1802.field_16307, 4, 1, 15, 20));
        }
        if (usevariantBookshelves) {
            registry.villagerTrade(profession, 4, () -> new GenericTradeOffers.TagForEmeralds(CharmonyTags.CHISELED_BOOKSHELVES, 4, 1, 1, 0, 15, 20));
        } else {
            registry.villagerTrade(profession, 4, () -> new GenericTradeOffers.ItemsForEmeralds((class_1935)class_1802.field_8536, 4, 1, 15, 20));
        }
        registry.villagerTrade(profession, 4, () -> new GenericTradeOffers.ItemsForEmeralds((class_1935)class_2246.field_10179, 7, 1, 1, 0, 15, 20));
        registry.villagerTrade(profession, 5, () -> new GenericTradeOffers.ItemsForEmeralds((class_1935)class_2246.field_10223, 11, 3, 1, 0, 15, 20));
        registry.villagerTrade(profession, 5, () -> new GenericTradeOffers.ItemsForEmeralds((class_1935)class_2246.field_16336, 5, 1, 1, 0, 30, 20));
        registry.villagerTrade(profession, 5, () -> new GenericTradeOffers.ItemsForEmeralds((class_1935)class_2246.field_10083, 4, 1, 1, 0, 30, 20));
        registry.villagerTrade(profession, 5, () -> new GenericTradeOffers.ItemsForEmeralds((class_1935)class_2246.field_17563, 3, 1, 1, 0, 30, 20));
    }

    public static void triggerTradedWithLumberjack(class_1657 player) {
        Advancements.trigger((class_2960)new class_2960("charm", "traded_with_lumberjack"), (class_1657)player);
    }
}

