/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.inventory_tidying;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_466;
import net.minecraft.class_476;
import net.minecraft.class_480;
import net.minecraft.class_481;
import net.minecraft.class_488;
import net.minecraft.class_490;
import net.minecraft.class_492;
import net.minecraft.class_495;
import svenhjol.charm.feature.inventory_tidying.InventoryTidying;
import svenhjol.charm.feature.inventory_tidying.InventoryTidyingNetwork;
import svenhjol.charm.feature.inventory_tidying.TidyType;
import svenhjol.charmony.api.CharmonyApi;
import svenhjol.charmony.api.event.ScreenRenderEvent;
import svenhjol.charmony.api.event.ScreenSetupEvent;
import svenhjol.charmony.api.iface.IContainerOffsetTweak;
import svenhjol.charmony.api.iface.IContainerOffsetTweakProvider;
import svenhjol.charmony.api.iface.IInventoryTidyingBlacklistProvider;
import svenhjol.charmony.api.iface.IInventoryTidyingWhitelistProvider;
import svenhjol.charmony.client.ClientFeature;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.helper.ApiHelper;
import svenhjol.charmony.helper.ScreenHelper;

public class InventoryTidyingClient
extends ClientFeature
implements IInventoryTidyingWhitelistProvider,
IInventoryTidyingBlacklistProvider,
IContainerOffsetTweakProvider {
    private static final int LEFT = 159;
    private static final int TOP = 12;
    private static final class_2960 INVENTORY_BUTTONS = new class_2960("charm", "textures/gui/inventory_buttons.png");
    private static final List<class_344> SORTING_BUTTONS = new ArrayList<class_344>();
    private static final List<Class<? extends class_437>> WHITELISTED_SCREENS = new ArrayList<Class<? extends class_437>>();
    private static final List<Class<? extends class_437>> BLACKLISTED_SCREENS = new ArrayList<Class<? extends class_437>>();
    private static final Map<Class<? extends class_437>, Pair<Integer, Integer>> CONTAINER_OFFSETS = new HashMap<Class<? extends class_437>, Pair<Integer, Integer>>();

    public Class<? extends CommonFeature> commonFeature() {
        return InventoryTidying.class;
    }

    public void register() {
        ApiHelper.consume(IContainerOffsetTweakProvider.class, provider -> provider.getContainerOffsetTweaks().forEach(tweak -> CONTAINER_OFFSETS.put(tweak.getScreen(), (Pair<Integer, Integer>)tweak.getOffset())));
        ApiHelper.consume(IInventoryTidyingWhitelistProvider.class, provider -> WHITELISTED_SCREENS.addAll(provider.getWhitelistedInventoryTidyingScreens()));
        ApiHelper.consume(IInventoryTidyingBlacklistProvider.class, provider -> BLACKLISTED_SCREENS.addAll(provider.getBlacklistedInventoryTidyingScreens()));
        CharmonyApi.registerProvider((Object)((Object)this));
    }

    public void runWhenEnabled() {
        ScreenSetupEvent.INSTANCE.handle(this::handleScreenSetup);
        ScreenRenderEvent.INSTANCE.handle(this::handleScreenRender);
    }

    private void handleScreenSetup(class_437 screen) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (!(screen instanceof class_465)) {
            return;
        }
        class_465 containerScreen = (class_465)screen;
        if (BLACKLISTED_SCREENS.contains(screen.getClass())) {
            return;
        }
        SORTING_BUTTONS.clear();
        Class<?> clazz = containerScreen.getClass();
        class_1703 menu = containerScreen.method_17577();
        int x = containerScreen.field_2776 + 159;
        int y = containerScreen.field_2800 - 12;
        if (CONTAINER_OFFSETS.containsKey(clazz)) {
            Pair<Integer, Integer> pair = CONTAINER_OFFSETS.get(clazz);
            x += ((Integer)pair.getFirst()).intValue();
            y += ((Integer)pair.getSecond()).intValue();
        }
        class_2371 slots = menu.field_7761;
        for (class_1735 slot : slots) {
            if (WHITELISTED_SCREENS.contains(containerScreen.getClass()) && slot.field_7874 == 0) {
                this.addSortingButton(screen, x, y + slot.field_7872, click -> InventoryTidyingNetwork.TidyInventory.send(TidyType.CONTAINER));
            }
            if (slot.field_7871 != client.field_1724.method_31548()) continue;
            this.addSortingButton(screen, x, y + slot.field_7872, click -> InventoryTidyingNetwork.TidyInventory.send(TidyType.PLAYER));
            break;
        }
        SORTING_BUTTONS.forEach(b -> ScreenHelper.addRenderableWidget((class_437)containerScreen, (class_364)b));
    }

    private void addSortingButton(class_437 screen, int x, int y, class_4185.class_4241 callback) {
        SORTING_BUTTONS.add(new class_344(x, y, 10, 10, 40, 0, 10, INVENTORY_BUTTONS, callback));
    }

    private void handleScreenRender(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY) {
        if (BLACKLISTED_SCREENS.contains(screen.getClass())) {
            return;
        }
        int x = screen.field_2776;
        SORTING_BUTTONS.forEach(button -> button.method_48229(x + 159, button.method_46427()));
    }

    public List<IContainerOffsetTweak> getContainerOffsetTweaks() {
        return List.of(new IContainerOffsetTweak(){

            public Class<? extends class_437> getScreen() {
                return class_492.class;
            }

            public Pair<Integer, Integer> getOffset() {
                return Pair.of((Object)100, (Object)0);
            }
        }, new IContainerOffsetTweak(){

            public Class<? extends class_437> getScreen() {
                return class_490.class;
            }

            public Pair<Integer, Integer> getOffset() {
                return Pair.of((Object)0, (Object)76);
            }
        });
    }

    public List<Class<? extends class_437>> getBlacklistedInventoryTidyingScreens() {
        return List.of(class_481.class, class_466.class);
    }

    public List<Class<? extends class_437>> getWhitelistedInventoryTidyingScreens() {
        return List.of(class_476.class, class_488.class, class_495.class, class_480.class);
    }
}

