/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.enchantable_horse_armor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4059;
import net.minecraft.class_7923;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.api.CharmonyApi;
import svenhjol.charmony.api.iface.IHorseArmorEnchantmentProvider;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.helper.ApiHelper;
import svenhjol.charmony.helper.PlayerHelper;

public class EnchantableHorseArmor
extends CommonFeature
implements IHorseArmorEnchantmentProvider {
    static final List<class_1887> ENCHANTMENTS = new ArrayList<class_1887>();
    @Configurable(name="Enchantments", description="Enchantments that will function on horse armor.")
    public static List<String> configEnchantments = Arrays.asList("minecraft:protection", "minecraft:fire_protection", "minecraft:blast_protection", "minecraft:projectile_protection", "minecraft:thorns", "minecraft:frost_walker", "minecraft:feather_falling", "minecraft:respiration", "minecraft:soul_speed");

    public String description() {
        return "Horse armor can be enchanted.";
    }

    public void register() {
        ApiHelper.consume(IHorseArmorEnchantmentProvider.class, provider -> provider.getEnchantments().forEach(this::addEnchantment));
        CharmonyApi.registerProvider((Object)((Object)this));
    }

    private void addEnchantment(class_1887 enchantment) {
        if (!ENCHANTMENTS.contains(enchantment)) {
            this.mod().log().debug(((Object)((Object)this)).getClass(), "Adding enchantment " + String.valueOf(enchantment), new Object[0]);
            ENCHANTMENTS.add(enchantment);
        }
    }

    public List<class_1887> getEnchantments() {
        ArrayList<class_1887> validatedEnchantments = new ArrayList<class_1887>();
        for (String enchantment : configEnchantments) {
            class_7923.field_41176.method_17966(new class_2960(enchantment)).ifPresent(validatedEnchantments::add);
        }
        return validatedEnchantments;
    }

    public static boolean canEnchant(class_1799 stack, class_1887 enchantment) {
        return stack.method_7909() instanceof class_4059 && EnchantableHorseArmor.getAllEnchantments().contains(enchantment);
    }

    public static List<class_1887> getAllEnchantments() {
        return ENCHANTMENTS;
    }

    public static void triggerAddEnchantmentToHorseArmor(class_3218 level, class_2338 pos) {
        List players = PlayerHelper.getPlayersInRange((class_1937)level, (class_2338)pos, (double)4.0);
        players.forEach(player -> Advancements.trigger((class_2960)new class_2960("charm", "equipped_enchanted_horse_armor"), (class_1657)player));
    }
}

