/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.atlases;

import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3910;
import net.minecraft.class_3917;
import net.minecraft.class_7701;
import svenhjol.charm.feature.atlases.AtlasContainer;
import svenhjol.charm.feature.atlases.AtlasInventory;
import svenhjol.charm.feature.atlases.AtlasItem;
import svenhjol.charm.feature.atlases.AtlasesNetwork;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.api.CharmonyApi;
import svenhjol.charmony.api.event.PlayerLoginEvent;
import svenhjol.charmony.api.event.PlayerTickEvent;
import svenhjol.charmony.api.iface.IWandererTrade;
import svenhjol.charmony.api.iface.IWandererTradeProvider;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.helper.ItemNbtHelper;
import svenhjol.charmony.iface.ICommonRegistry;

public class Atlases
extends CommonFeature
implements IWandererTradeProvider {
    public static Supplier<class_1792> ITEM;
    public static Supplier<class_3917<AtlasContainer>> MENU_TYPE;
    public static Supplier<class_3414> OPEN_SOUND;
    public static Supplier<class_3414> CLOSE_SOUND;
    private static final int NUMBER_OF_MAPS_FOR_ACHIEVEMENT = 10;
    @Configurable(name="Open in off hand", description="Allow opening the atlas while it is in the off-hand.")
    public static boolean offHandOpen;
    @Configurable(name="Map scale", description="Map scale used in atlases by default.")
    public static int defaultScale;

    public String description() {
        return "Storage for maps that automatically updates the displayed map as you explore.";
    }

    public void register() {
        ICommonRegistry registry = this.mod().registry();
        ITEM = registry.item("atlas", () -> new AtlasItem(this));
        MENU_TYPE = registry.menuType("atlas", () -> new class_3917(AtlasContainer::new, class_7701.field_40182));
        OPEN_SOUND = registry.soundEvent("atlas_open");
        CLOSE_SOUND = registry.soundEvent("atlas_close");
        AtlasesNetwork.register();
        CharmonyApi.registerProvider((Object)((Object)this));
    }

    public void runWhenEnabled() {
        PlayerLoginEvent.INSTANCE.handle(this::handlePlayerLogin);
        PlayerTickEvent.INSTANCE.handle(this::handlePlayerTick);
    }

    public static void handleTransferAtlas(AtlasesNetwork.TransferAtlas request, class_1657 player) {
        int atlasSlot = request.getAtlasSlot();
        int mapX = request.getMapX();
        int mapZ = request.getMapZ();
        AtlasInventory inventory = AtlasInventory.get(player.method_37908(), player.method_31548().method_5438(atlasSlot));
        switch (request.getMoveMode()) {
            case TO_HAND: {
                player.field_7512.method_34254(inventory.removeMapByCoords((class_1937)player.method_37908(), (int)mapX, (int)mapZ).map);
                AtlasesNetwork.UpdateInventory.send(player, atlasSlot);
                break;
            }
            case TO_INVENTORY: {
                player.method_7270(inventory.removeMapByCoords((class_1937)player.method_37908(), (int)mapX, (int)mapZ).map);
                AtlasesNetwork.UpdateInventory.send(player, atlasSlot);
                break;
            }
            case FROM_HAND: {
                Integer mapId;
                class_22 mapState;
                class_1799 heldItem = player.field_7512.method_34255();
                if (heldItem.method_7909() != class_1802.field_8204 || (mapState = class_1806.method_7997((Integer)(mapId = class_1806.method_8003((class_1799)heldItem)), (class_1937)player.method_37908())) == null || mapState.field_119 != inventory.getScale()) break;
                inventory.addToInventory(player.method_37908(), heldItem);
                player.field_7512.method_34254(class_1799.field_8037);
                AtlasesNetwork.UpdateInventory.send(player, atlasSlot);
                break;
            }
            case FROM_INVENTORY: {
                Integer mapId;
                class_22 mapState;
                class_1799 stack = player.method_31548().method_5438(mapX);
                if (stack.method_7909() != class_1802.field_8204 || (mapState = class_1806.method_7997((Integer)(mapId = class_1806.method_8003((class_1799)stack)), (class_1937)player.method_37908())) == null || mapState.field_119 != inventory.getScale()) break;
                inventory.addToInventory(player.method_37908(), stack);
                player.method_31548().method_5441(mapX);
                AtlasesNetwork.UpdateInventory.send(player, atlasSlot);
            }
        }
    }

    private void handlePlayerLogin(class_1657 player) {
        if (!player.method_37908().method_8608()) {
            AtlasesNetwork.SwappedAtlasSlot.send(player, -1);
        }
    }

    private void handlePlayerTick(class_1657 player) {
        if (!player.method_37908().field_9236) {
            class_3222 serverPlayer = (class_3222)player;
            for (class_1268 hand : class_1268.values()) {
                AtlasInventory inventory;
                class_1799 held = serverPlayer.method_5998(hand);
                if (held.method_7909() != ITEM.get() || !(inventory = AtlasInventory.get(serverPlayer.method_37908(), held)).updateActiveMap(serverPlayer)) continue;
                int slot = Atlases.getSlotFromHand((class_1657)serverPlayer, hand);
                AtlasesNetwork.UpdateInventory.send(player, slot);
                if (inventory.getMapInfos().size() < 10) continue;
                Atlases.triggerMadeAtlasMaps((class_1657)serverPlayer);
            }
        }
    }

    public static boolean doesAtlasContainMap(class_1661 inventory, class_1799 stack) {
        if (inventory.method_7379(stack)) {
            return true;
        }
        for (class_1268 hand : class_1268.values()) {
            AtlasInventory inv;
            class_1799 atlasStack = inventory.field_7546.method_5998(hand);
            if (atlasStack.method_7909() != ITEM.get() || !(inv = AtlasInventory.get(inventory.field_7546.method_37908(), atlasStack)).hasItemStack(stack)) continue;
            return true;
        }
        return false;
    }

    public static void setupAtlasUpscale(final class_1661 playerInventory, class_3910 container) {
        final class_1735 oldSlot = (class_1735)container.field_7761.get(0);
        container.field_7761.set(0, (Object)new class_1735(oldSlot.field_7871, oldSlot.field_7874, oldSlot.field_7873, oldSlot.field_7872){

            public boolean method_7680(class_1799 stack) {
                return oldSlot.method_7680(stack) || stack.method_7909() == ITEM.get() && AtlasInventory.get(playerInventory.field_7546.method_37908(), stack).getMapInfos().isEmpty();
            }
        });
    }

    public static boolean makeAtlasUpscaleOutput(class_1799 topStack, class_1799 bottomStack, class_1799 outputStack, class_1937 level, class_1731 craftResultInventory, class_3910 cartographyContainer) {
        if (topStack.method_7909() == ITEM.get()) {
            class_1799 output;
            AtlasInventory inventory = AtlasInventory.get(level, topStack);
            if (inventory.getMapInfos().isEmpty() && bottomStack.method_7909() == class_1802.field_8895 && inventory.getScale() < 4) {
                output = topStack.method_7972();
                ItemNbtHelper.setUuid((class_1799)output, (String)"id", (UUID)UUID.randomUUID());
                ItemNbtHelper.setInt((class_1799)output, (String)"scale", (int)(inventory.getScale() + 1));
            } else {
                output = class_1799.field_8037;
            }
            if (!class_1799.method_7973((class_1799)output, (class_1799)outputStack)) {
                craftResultInventory.method_5447(2, output);
                cartographyContainer.method_7623();
            }
            return true;
        }
        return false;
    }

    public static int getSlotFromHand(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return player.method_31548().field_7545;
        }
        return player.method_31548().method_5439() - 1;
    }

    public static void handleSwappedSlot(AtlasesNetwork.SwapAtlasSlot request, class_1657 player) {
        int swappedSlot = request.getSlot();
        class_1799 offhandItem = player.method_6079().method_7972();
        class_1799 mainHandItem = player.method_6047().method_7972();
        class_1661 inventory = player.method_31548();
        Consumer<Integer> doSwap = i -> {
            class_1799 swap = inventory.method_5438(i.intValue()).method_7972();
            inventory.method_5447(i.intValue(), mainHandItem);
            player.method_6122(class_1268.field_5808, swap);
            AtlasesNetwork.SwappedAtlasSlot.send(player, i);
        };
        if (mainHandItem.method_7909() instanceof AtlasItem && swappedSlot >= 0) {
            doSwap.accept(swappedSlot);
            return;
        }
        if (offhandItem.method_7909() instanceof AtlasItem) {
            return;
        }
        int slot = -1;
        for (int i2 = 0; i2 < 36; ++i2) {
            class_1799 inv = inventory.method_5438(i2);
            if (!(inv.method_7909() instanceof AtlasItem)) continue;
            slot = i2;
            break;
        }
        if (slot == -1) {
            return;
        }
        doSwap.accept(slot);
    }

    public List<IWandererTrade> getWandererTrades() {
        return List.of(new IWandererTrade(){

            public class_1935 getItem() {
                return (class_1935)ITEM.get();
            }

            public int getCount() {
                return 1;
            }

            public int getCost() {
                return 5;
            }
        });
    }

    public static void triggerMadeAtlasMaps(class_1657 player) {
        Advancements.trigger((class_2960)new class_2960("charm", "made_atlas_maps"), (class_1657)player);
    }

    static {
        offHandOpen = false;
        defaultScale = 0;
    }
}

