/*
 * Decompiled with CFR 0.152.
 */
package net.masik.mythiccharms.util;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.masik.mythiccharms.MythicCharms;
import net.masik.mythiccharms.item.ModItems;
import net.masik.mythiccharms.particle.ModParticles;
import net.masik.mythiccharms.util.MythicCharmsConfig;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class CharmHelper {
    private static final String FEATHERED_GRACE = "feathered_grace";
    private static final String BLAZING_EMBRACE = "blazing_embrace";
    private static final String EARTHS_ORDER = "earths_order";
    private static final String GAZE_SERENITY = "gaze_serenity";
    private static final String BOTANIC_BLESSING = "botanic_blessing";
    private static final String FLEETING_STRIDES = "fleeting_strides";
    private static final String NIGHTS_GUARDIAN = "nights_guardian";
    private static final String HIGH_BOUNDS = "high_bounds";
    private static final String DROWNED_FREEDOM = "drowned_freedom";
    private static final String WEIGHTLESS_FLOW = "weightless_flow";
    private static final String COLLECTORS_GIFT = "collectors_gift";
    private static final String CLIMBERS_PATH = "climbers_path";
    private static final String NATURES_CALL = "natures_call";
    private static final String BARTERS_PACT = "barters_pact";
    private static final String BATTLE_FURY = "battle_fury";
    private static final String ECHOING_WRATH = "echoing_wrath";
    private static final String ENCHANTED_WHISPERS = "enchanted_whispers";
    private static final String ARROW_DANCE = "arrow_dance";
    private static final String MOUNTAINS_STRENGTH = "mountains_strength";
    private static final String SAFE_TERRITORY = "safe_territory";
    private static final String QUIET_PRESENCE = "quiet_presence";
    private static final MythicCharmsConfig config = MythicCharms.CONFIG;
    public static final ArrayList<Set<String>> COMBINATIONS = new ArrayList<Set<String>>(){
        {
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.FEATHERED_GRACE, CharmHelper.HIGH_BOUNDS})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.BLAZING_EMBRACE, CharmHelper.BATTLE_FURY})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.EARTHS_ORDER, CharmHelper.BLAZING_EMBRACE})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.EARTHS_ORDER, CharmHelper.DROWNED_FREEDOM})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.EARTHS_ORDER, CharmHelper.WEIGHTLESS_FLOW})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.EARTHS_ORDER, CharmHelper.BATTLE_FURY})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.BOTANIC_BLESSING, CharmHelper.FEATHERED_GRACE})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.FLEETING_STRIDES, CharmHelper.HIGH_BOUNDS})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.FLEETING_STRIDES, CharmHelper.BATTLE_FURY})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.WEIGHTLESS_FLOW, CharmHelper.FEATHERED_GRACE})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.CLIMBERS_PATH, CharmHelper.HIGH_BOUNDS})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.ECHOING_WRATH, CharmHelper.BLAZING_EMBRACE})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.ECHOING_WRATH, CharmHelper.BATTLE_FURY})));
            this.add(new HashSet<String>(List.of(new String[]{CharmHelper.QUIET_PRESENCE, CharmHelper.FEATHERED_GRACE})));
        }
    };
    public static final Map<String, class_2400> PARTICLES = new HashMap<String, class_2400>(){
        {
            this.put(CharmHelper.FEATHERED_GRACE, ModParticles.FEATHERED_GRACE_EQUIP_PARTICLE);
            this.put(CharmHelper.BLAZING_EMBRACE, ModParticles.BLAZING_EMBRACE_EQUIP_PARTICLE);
            this.put(CharmHelper.EARTHS_ORDER, ModParticles.EARTHS_ORDER_EQUIP_PARTICLE);
            this.put(CharmHelper.GAZE_SERENITY, ModParticles.GAZE_SERENITY_EQUIP_PARTICLE);
            this.put(CharmHelper.BOTANIC_BLESSING, ModParticles.BOTANIC_BLESSING_EQUIP_PARTICLE);
            this.put(CharmHelper.FLEETING_STRIDES, ModParticles.FLEETING_STRIDES_EQUIP_PARTICLE);
            this.put(CharmHelper.NIGHTS_GUARDIAN, ModParticles.NIGHTS_GUARDIAN_EQUIP_PARTICLE);
            this.put(CharmHelper.HIGH_BOUNDS, ModParticles.HIGH_BOUNDS_EQUIP_PARTICLE);
            this.put(CharmHelper.DROWNED_FREEDOM, ModParticles.DROWNED_FREEDOM_EQUIP_PARTICLE);
            this.put(CharmHelper.WEIGHTLESS_FLOW, ModParticles.WEIGHTLESS_FLOW_EQUIP_PARTICLE);
            this.put(CharmHelper.COLLECTORS_GIFT, ModParticles.COLLECTORS_GIFT_EQUIP_PARTICLE);
            this.put(CharmHelper.CLIMBERS_PATH, ModParticles.CLIMBERS_PATH_EQUIP_PARTICLE);
            this.put(CharmHelper.NATURES_CALL, ModParticles.NATURES_CALL_EQUIP_PARTICLE);
            this.put(CharmHelper.BARTERS_PACT, ModParticles.BARTERS_PACT_EQUIP_PARTICLE);
            this.put(CharmHelper.BATTLE_FURY, ModParticles.BATTLE_FURY_EQUIP_PARTICLE);
            this.put(CharmHelper.ECHOING_WRATH, ModParticles.ECHOING_WRATH_EQUIP_PARTICLE);
            this.put(CharmHelper.ENCHANTED_WHISPERS, ModParticles.ENCHANTED_WHISPERS_EQUIP_PARTICLE);
            this.put(CharmHelper.ARROW_DANCE, ModParticles.ARROW_DANCE_EQUIP_PARTICLE);
            this.put(CharmHelper.MOUNTAINS_STRENGTH, ModParticles.MOUNTAINS_STRENGTH_EQUIP_PARTICLE);
            this.put(CharmHelper.SAFE_TERRITORY, ModParticles.SAFE_TERRITORY_EQUIP_PARTICLE);
            this.put(CharmHelper.QUIET_PRESENCE, ModParticles.QUIET_PRESENCE_EQUIP_PARTICLE);
        }
    };
    public static final ArrayList<class_1792> PATTERNS = new ArrayList<class_1792>(){
        {
            this.add(ModItems.SOUND_CARVING_PATTERN_ARROW_DANCE);
            this.add(ModItems.SOUND_CARVING_PATTERN_FEATHERED_GRACE);
            this.add(ModItems.SOUND_CARVING_PATTERN_BLAZING_EMBRACE);
            this.add(ModItems.SOUND_CARVING_PATTERN_QUIET_PRESENCE);
            this.add(ModItems.SOUND_CARVING_PATTERN_BARTERS_PACT);
            this.add(ModItems.SOUND_CARVING_PATTERN_BOTANIC_BLESSING);
            this.add(ModItems.SOUND_CARVING_PATTERN_BATTLE_FURY);
            this.add(ModItems.SOUND_CARVING_PATTERN_CLIMBERS_PATH);
            this.add(ModItems.SOUND_CARVING_PATTERN_DROWNED_FREEDOM);
            this.add(ModItems.SOUND_CARVING_PATTERN_COLLECTORS_GIFT);
            this.add(ModItems.SOUND_CARVING_PATTERN_EARTHS_ORDER);
            this.add(ModItems.SOUND_CARVING_PATTERN_ECHOING_WRATH);
            this.add(ModItems.SOUND_CARVING_PATTERN_ENCHANTED_WHISPERS);
            this.add(ModItems.SOUND_CARVING_PATTERN_FLEETING_STRIDES);
            this.add(ModItems.SOUND_CARVING_PATTERN_GAZE_SERENITY);
            this.add(ModItems.SOUND_CARVING_PATTERN_HIGH_BOUNDS);
            this.add(ModItems.SOUND_CARVING_PATTERN_MOUNTAINS_STRENGTH);
            this.add(ModItems.SOUND_CARVING_PATTERN_NATURES_CALL);
            this.add(ModItems.SOUND_CARVING_PATTERN_NIGHTS_GUARDIAN);
            this.add(ModItems.SOUND_CARVING_PATTERN_SAFE_TERRITORY);
            this.add(ModItems.SOUND_CARVING_PATTERN_WEIGHTLESS_FLOW);
        }
    };

    public static boolean charmFeatheredGraceEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmFeatheredGraceEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, FEATHERED_GRACE);
    }

    public static boolean charmBlazingEmbraceEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmBlazingEmbraceEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, BLAZING_EMBRACE);
    }

    public static boolean charmEarthsOrderEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmEarthsOrderEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, EARTHS_ORDER);
    }

    public static boolean charmGazeSerenityEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmGazeSerenityEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, GAZE_SERENITY);
    }

    public static boolean charmBotanicBlessingEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmBotanicBlessingEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, BOTANIC_BLESSING);
    }

    public static boolean charmFleetingStridesEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmFleetingStridesEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, FLEETING_STRIDES);
    }

    public static boolean charmNightsGuardianEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmNightsGuardianEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, NIGHTS_GUARDIAN);
    }

    public static boolean charmHighBoundsEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmHighBoundsEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, HIGH_BOUNDS);
    }

    public static boolean charmDrownedFreedomEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmDrownedFreedomEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, DROWNED_FREEDOM);
    }

    public static boolean charmWeightlessFlowEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmWeightlessFlowEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, WEIGHTLESS_FLOW);
    }

    public static boolean charmCollectorsGiftEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmCollectorsGiftEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, COLLECTORS_GIFT);
    }

    public static boolean charmClimbersPathEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmClimbersPathEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, CLIMBERS_PATH);
    }

    public static boolean charmNaturesCallEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmNaturesCallEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, NATURES_CALL);
    }

    public static boolean charmBartersPactEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmBartersPactEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, BARTERS_PACT);
    }

    public static boolean charmBattleFuryEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmBattleFuryEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, BATTLE_FURY);
    }

    public static boolean charmEchoingWrathEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmEchoingWrathEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, ECHOING_WRATH);
    }

    public static boolean charmEnchantedWhispersEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmEnchantedWhispersEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, ENCHANTED_WHISPERS);
    }

    public static boolean charmArrowDanceEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmArrowDanceEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, ARROW_DANCE);
    }

    public static boolean charmMountainsStrengthEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmMountainsStrengthEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, MOUNTAINS_STRENGTH);
    }

    public static boolean charmSafeTerritoryEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmSafeTerritoryEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, SAFE_TERRITORY);
    }

    public static boolean charmQuietPresenceEquipped(class_1309 entity) {
        if (!CharmHelper.config.charmsEnabled.CharmQuietPresenceEnabled()) {
            return false;
        }
        return CharmHelper.isCharmEquipped(entity, QUIET_PRESENCE);
    }

    public static boolean charmCombinationFeatheredGraceAndHighBoundsEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationFeatheredGraceAndHighBoundsEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, FEATHERED_GRACE, HIGH_BOUNDS);
    }

    public static boolean charmCombinationBlazingEmbraceAndBattleFuryEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationBlazingEmbraceAndBattleFuryEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, BLAZING_EMBRACE, BATTLE_FURY);
    }

    public static boolean charmCombinationEarthsOrderAndBlazingEmbraceEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationEarthsOrderAndBlazingEmbraceEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, EARTHS_ORDER, BLAZING_EMBRACE);
    }

    public static boolean charmCombinationEarthsOrderAndDrownedFreedomEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationEarthsOrderAndDrownedFreedomEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, EARTHS_ORDER, DROWNED_FREEDOM);
    }

    public static boolean charmCombinationEarthsOrderAndWeightlessFlowEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationEarthsOrderAndWeightlessFlowEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, EARTHS_ORDER, WEIGHTLESS_FLOW);
    }

    public static boolean charmCombinationEarthsOrderAndBattleFuryEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationEarthsOrderAndBattleFuryEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, EARTHS_ORDER, BATTLE_FURY);
    }

    public static boolean charmCombinationBotanicBlessingAndFeatheredGraceEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationBotanicBlessingAndFeatheredGraceEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, BOTANIC_BLESSING, FEATHERED_GRACE);
    }

    public static boolean charmCombinationFleetingStridesAndHighBoundsEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationFleetingStridesAndHighBoundsEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, FLEETING_STRIDES, HIGH_BOUNDS);
    }

    public static boolean charmCombinationFleetingStridesAndBattleFuryEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationFleetingStridesAndBattleFuryEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, FLEETING_STRIDES, BATTLE_FURY);
    }

    public static boolean charmCombinationWeightlessFlowAndFeatheredGraceEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationWeightlessFlowAndFeatheredGraceEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, WEIGHTLESS_FLOW, FEATHERED_GRACE);
    }

    public static boolean charmCombinationClimbersPathAndHighBoundsEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationClimbersPathAndHighBoundsEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, CLIMBERS_PATH, HIGH_BOUNDS);
    }

    public static boolean charmCombinationEchoingWrathAndBlazingEmbraceEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationEchoingWrathAndBlazingEmbraceEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, ECHOING_WRATH, BLAZING_EMBRACE);
    }

    public static boolean charmCombinationEchoingWrathAndBattleFuryEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationEchoingWrathAndBattleFuryEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, ECHOING_WRATH, BATTLE_FURY);
    }

    public static boolean charmCombinationQuietPresenceAndFeatheredGraceEnabled(class_1309 entity) {
        if (!CharmHelper.config.charmCombinationsEnabled.CharmCombinationQuietPresenceAndFeatheredGraceEnabled()) {
            return false;
        }
        return CharmHelper.isCharmsComboEquipped(entity, QUIET_PRESENCE, FEATHERED_GRACE);
    }

    private static boolean isCharmsComboEquipped(class_1309 entity, String name_1, String name_2) {
        Optional trinket = TrinketsApi.getTrinketComponent((class_1309)entity);
        return trinket.isPresent() && ((TrinketComponent)trinket.get()).isEquipped(stack -> CharmHelper.isStackInCharmTag(stack, name_1)) && ((TrinketComponent)trinket.get()).isEquipped(stack -> CharmHelper.isStackInCharmTag(stack, name_2));
    }

    private static boolean isCharmEquipped(class_1309 entity, String name) {
        Optional trinket = TrinketsApi.getTrinketComponent((class_1309)entity);
        return trinket.isPresent() && ((TrinketComponent)trinket.get()).isEquipped(stack -> CharmHelper.isStackInCharmTag(stack, name));
    }

    private static boolean isStackInCharmTag(class_1799 stack, String name) {
        return stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("mythic_charms", "charms/" + name)));
    }
}

