/*
 * Decompiled with CFR 0.152.
 */
package net.masik.mythiccharms.mixin;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.masik.mythiccharms.item.ModItems;
import net.masik.mythiccharms.util.AdvancementsHelper;
import net.masik.mythiccharms.util.CharmHelper;
import net.masik.mythiccharms.util.ParticleHelper;
import net.masik.mythiccharms.util.SoundHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Trinket.class})
public interface TrinketMixin {
    @Inject(method={"onEquip"}, at={@At(value="RETURN")})
    private void onEquipCharm(class_1799 stack, SlotReference slot, class_1309 entity, CallbackInfo ci) {
        if (!stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("trinkets:mythic_charm/mythic_charm")))) {
            return;
        }
        if (stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("mythic_charms", "fragile_charms")))) {
            this.dealDamage(entity, this.doesResonanceRingNullifyDamage(entity) ? 0.0f : 2.0f, class_3417.field_26974);
            this.summonParticles(entity, stack);
            this.checkCombo(entity);
        } else if (stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("mythic_charms", "unbreakable_charms")))) {
            this.dealDamage(entity, 0.0f, class_3417.field_28973);
            this.summonParticles(entity, stack);
            this.checkCombo(entity);
        }
    }

    @Inject(method={"onUnequip"}, at={@At(value="RETURN")})
    private void onUnequipCharm(class_1799 stack, SlotReference slot, class_1309 entity, CallbackInfo ci) {
        if (!stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("trinkets:mythic_charm/mythic_charm")))) {
            return;
        }
        if (stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("mythic_charms", "fragile_charms")))) {
            this.dealDamage(entity, this.doesResonanceRingNullifyDamage(entity) ? 0.0f : 2.0f, class_3417.field_26974);
        } else if (stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("mythic_charms", "unbreakable_charms")))) {
            this.dealDamage(entity, 0.0f, class_3417.field_28973);
        }
    }

    @Unique
    private boolean doesResonanceRingNullifyDamage(class_1309 entity) {
        Optional trinket = TrinketsApi.getTrinketComponent((class_1309)entity);
        if (trinket.isEmpty() || !((TrinketComponent)trinket.get()).isEquipped(ModItems.RESONANCE_RING)) {
            return false;
        }
        class_5819 random = class_5819.method_43047();
        return random.method_43057() < 0.3f;
    }

    @Unique
    private void summonParticles(class_1309 entity, class_1799 stack) {
        if (!entity.method_31747()) {
            return;
        }
        class_1657 player = (class_1657)entity;
        String charmName = stack.toString();
        ParticleHelper.spawnParticle(player, CharmHelper.PARTICLES.get(charmName.substring(charmName.indexOf("of_") + 3)), player.method_23317() + Math.sin(Math.toRadians(player.method_36454() + 180.0f)) * -0.5, player.method_23318() + 1.5, player.method_23321() + Math.cos(Math.toRadians(player.method_36454() + 180.0f)) * 0.5, 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Unique
    private void dealDamage(class_1309 entity, float amount, class_3414 soundEvent) {
        entity.method_5643(entity.method_48923().method_48831(), amount);
        SoundHelper.playSoundAtEntity(entity, soundEvent, 40.0f);
    }

    @Unique
    private void checkCombo(class_1309 entity) {
        HashSet<String> charmsEquipped = new HashSet<String>();
        Optional trinket = TrinketsApi.getTrinketComponent((class_1309)entity);
        if (trinket.isEmpty()) {
            return;
        }
        for (class_3545 class_35452 : ((TrinketComponent)trinket.get()).getAllEquipped()) {
            String charmName = ((class_1799)class_35452.method_15441()).toString();
            charmsEquipped.add(charmName.substring(charmName.indexOf("of_") + 3));
        }
        for (Set set : CharmHelper.COMBINATIONS) {
            if (!charmsEquipped.containsAll(set)) continue;
            SoundHelper.playSoundAtEntity(entity, class_3417.field_43154, 40.0f);
            AdvancementsHelper.grantAdvancement(entity, new class_2960("mythic_charms", "story/equip_combination"));
        }
    }
}

