/*
 * Decompiled with CFR 0.152.
 */
package net.masik.mythiccharms.mixin;

import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import net.masik.mythiccharms.item.ModItems;
import net.masik.mythiccharms.particle.ModParticles;
import net.masik.mythiccharms.util.AdvancementsHelper;
import net.masik.mythiccharms.util.BattleFuryHelper;
import net.masik.mythiccharms.util.CharmHelper;
import net.masik.mythiccharms.util.ParticleHelper;
import net.masik.mythiccharms.util.SoundHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1890;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerMixin {
    @Inject(method={"dropInventory"}, at={@At(value="HEAD")})
    private void destroyFragileCharms(CallbackInfo info) {
        class_1657 player = (class_1657)this;
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinkets -> trinkets.forEach((ref, stack) -> {
            if (stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("mythic_charms", "fragile_charms")))) {
                SoundHelper.playSoundAtEntity((class_1309)player, class_3417.field_15075, 20.0f);
                ref.inventory().method_5447(ref.index(), ModItems.BROKEN_CHARM.method_7854());
                AdvancementsHelper.grantAdvancement((class_1309)player, new class_2960("mythic_charms", "story/broken_charm"));
            }
        }));
    }

    @Inject(method={"canHarvest"}, at={@At(value="RETURN")}, cancellable=true)
    private void earthsOrderEffect(class_2680 state, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmEarthsOrderEquipped((class_1309)player)) {
            return;
        }
        if (player.method_6047().method_7963()) {
            return;
        }
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"getBlockBreakingSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void earthsOrderEffectSpeed(class_2680 block, CallbackInfoReturnable<Float> cir) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmEarthsOrderEquipped((class_1309)player)) {
            return;
        }
        if (player.method_6047().method_7963()) {
            return;
        }
        float speedModifier = 3.5f;
        if (CharmHelper.charmBattleFuryEquipped((class_1309)player) && CharmHelper.charmCombinationEarthsOrderAndBattleFuryEnabled((class_1309)player)) {
            speedModifier *= (float)BattleFuryHelper.getMultiplier(player);
        }
        if (CharmHelper.charmDrownedFreedomEquipped((class_1309)player) && CharmHelper.charmCombinationEarthsOrderAndDrownedFreedomEnabled((class_1309)player) && player.method_5777(class_3486.field_15517) && !class_1890.method_8200((class_1309)player)) {
            speedModifier += 5.0f;
        }
        if (CharmHelper.charmWeightlessFlowEquipped((class_1309)player) && CharmHelper.charmCombinationEarthsOrderAndWeightlessFlowEnabled((class_1309)player) && !player.method_24828()) {
            speedModifier += 5.0f;
        }
        cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * speedModifier));
    }

    @Inject(method={"getOffGroundSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void fleetingStridesEffect(CallbackInfoReturnable<Float> cir) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmFleetingStridesEquipped((class_1309)player)) {
            return;
        }
        if (!player.method_5624() || player.method_31549().field_7479) {
            return;
        }
        float speed = 0.035f;
        if (CharmHelper.charmHighBoundsEquipped((class_1309)player) && CharmHelper.charmCombinationFleetingStridesAndHighBoundsEnabled((class_1309)player)) {
            speed += 0.01f;
        }
        if (CharmHelper.charmBattleFuryEquipped((class_1309)player) && CharmHelper.charmCombinationFleetingStridesAndBattleFuryEnabled((class_1309)player)) {
            speed += (float)((double)0.02f * BattleFuryHelper.getMultiplier(player));
        }
        cir.setReturnValue((Object)Float.valueOf(speed));
    }

    @Inject(method={"setFireTicks"}, at={@At(value="RETURN")})
    private void blazingEmbraceEffect(int fireTicks, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmBlazingEmbraceEquipped((class_1309)player)) {
            return;
        }
        if (!player.method_5809()) {
            float duration = 410.0f;
            if (CharmHelper.charmBattleFuryEquipped((class_1309)player) && CharmHelper.charmCombinationBlazingEmbraceAndBattleFuryEnabled((class_1309)player)) {
                duration *= (float)BattleFuryHelper.getMultiplier(player);
            }
            player.method_6092(new class_1293(class_1294.field_5918, (int)duration, 0, false, false, true));
        } else if (!player.field_28629) {
            ParticleHelper.spawnParticle(player, ModParticles.BLAZING_EMBRACE_EFFECT_PARTICLE, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 20, 0.1, 0.1, 0.1, 0.06);
        }
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"), index=1)
    private float battleFuryEffect(float amount) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmBattleFuryEquipped((class_1309)player)) {
            return amount;
        }
        return (float)((double)amount * BattleFuryHelper.getMultiplier(player));
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    private void echoingWrathEffect(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmEchoingWrathEquipped((class_1309)player) || source.method_5529() == null) {
            return;
        }
        class_238 box = class_238.method_29968((class_243)player.method_19538()).method_1014(2.0);
        ArrayList entities = new ArrayList(player.method_37908().method_8390(class_1309.class, box, entity -> true));
        entities.forEach(entity -> {
            if (entity instanceof class_1321 && ((class_1321)entity).method_6171((class_1309)player)) {
                return;
            }
            float damageMultiplier = 1.0f;
            if (CharmHelper.charmBattleFuryEquipped((class_1309)player) && CharmHelper.charmCombinationEchoingWrathAndBattleFuryEnabled((class_1309)player)) {
                damageMultiplier *= (float)BattleFuryHelper.getMultiplier(player);
            }
            if (CharmHelper.charmBlazingEmbraceEquipped((class_1309)player) && CharmHelper.charmCombinationEchoingWrathAndBlazingEmbraceEnabled((class_1309)player)) {
                damageMultiplier *= 0.5f;
                entity.method_20803(60);
            }
            entity.method_5643(player.method_48923().method_48831(), amount / 2.0f > 10.0f ? 5.0f * damageMultiplier : amount / 2.0f * damageMultiplier);
            entity.method_18799(entity.method_18798().method_1019(player.method_19538().method_1020(entity.method_19538()).method_1021((double)-0.3f)));
            entity.field_6037 = true;
            class_5819 random = class_5819.method_43047();
            if (random.method_43048(10) < 7) {
                ParticleHelper.spawnParticle(player, ModParticles.ECHOING_WRATH_EFFECT_PARTICLE, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), random.method_39332(4, 8), 0.1, 0.1, 0.1, 0.08);
            }
        });
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"), index=1)
    private float echoingWrathDealLessDamage(float amount) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmEchoingWrathEquipped((class_1309)player)) {
            return amount;
        }
        return (float)((double)amount * 0.75);
    }

    @ModifyArg(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"), index=1)
    private float mountainsStrengthReceiveMoreDamage(float amount) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmMountainsStrengthEquipped((class_1309)player)) {
            return amount;
        }
        class_5819 random = class_5819.method_43047();
        if (random.method_43048(10) < 4) {
            ParticleHelper.spawnParticle(player, ModParticles.MOUNTAINS_STRENGTH_EFFECT_PARTICLE, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 1, 0.1, 0.1, 0.1, 0.06);
        }
        return (float)((double)amount * 1.25);
    }

    @Inject(method={"canBeHitByProjectile"}, at={@At(value="RETURN")}, cancellable=true)
    private void arrowDanceEffect(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmArrowDanceEquipped((class_1309)player)) {
            return;
        }
        if (!player.method_5715()) {
            return;
        }
        class_5819 random = class_5819.method_43047();
        if (random.method_43048(10) < 3) {
            ParticleHelper.spawnParticle(player, ModParticles.ARROW_DANCE_EFFECT_PARTICLE, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), random.method_39332(3, 6), 0.1, 0.1, 0.1, 0.06);
        }
        cir.setReturnValue((Object)false);
    }

    @ModifyArg(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"), index=1)
    private float arrowDanceReceiveMoreDamage(float amount) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmArrowDanceEquipped((class_1309)player)) {
            return amount;
        }
        return (float)((double)amount * 1.25);
    }

    @Inject(method={"travel"}, at={@At(value="RETURN")})
    private void climbersPathHungerWhileRunning(class_243 movementInput, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmClimbersPathEquipped((class_1309)player)) {
            return;
        }
        if (!player.method_5624()) {
            return;
        }
        player.method_7322(0.05f);
    }

    @Inject(method={"travel"}, at={@At(value="RETURN")})
    private void weightlessFlowHungerWhileRunning(class_243 movementInput, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmWeightlessFlowEquipped((class_1309)player)) {
            return;
        }
        if (!player.method_5624()) {
            return;
        }
        player.method_7322(0.05f);
    }

    @Inject(method={"travel"}, at={@At(value="RETURN")})
    private void drownedFreedomHungerWhileRunning(class_243 movementInput, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (!CharmHelper.charmDrownedFreedomEquipped((class_1309)player)) {
            return;
        }
        if (!player.method_5624()) {
            return;
        }
        player.method_7322(0.05f);
    }
}

