/*
 * Decompiled with CFR 0.152.
 */
package net.masik.mythiccharms.mixin;

import dev.emi.trinkets.api.TrinketsApi;
import net.masik.mythiccharms.item.ModItems;
import net.masik.mythiccharms.particle.ModParticles;
import net.masik.mythiccharms.util.AdvancementsHelper;
import net.masik.mythiccharms.util.BattleFuryHelper;
import net.masik.mythiccharms.util.CharmHelper;
import net.masik.mythiccharms.util.ParticleHelper;
import net.masik.mythiccharms.util.SoundHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Inject(method={"tryUseTotem"}, at={@At(value="RETURN")})
    private void destroyFragileCharms(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            class_1309 player = (class_1309)this;
            TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinkets -> trinkets.forEach((ref, stack) -> {
                if (stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("mythic_charms", "fragile_charms")))) {
                    SoundHelper.playSoundAtEntity(player, class_3417.field_15075, 20.0f);
                    ref.inventory().method_5447(ref.index(), ModItems.BROKEN_CHARM.method_7854());
                    AdvancementsHelper.grantAdvancement(player, new class_2960("mythic_charms", "story/broken_charm"));
                }
            }));
        }
    }

    @Inject(method={"getJumpVelocity"}, at={@At(value="RETURN")}, cancellable=true)
    private void highBoundsEffectJump(CallbackInfoReturnable<Float> cir) {
        class_5819 random;
        class_1309 entity = (class_1309)this;
        if (!entity.method_31747()) {
            return;
        }
        if (!CharmHelper.charmHighBoundsEquipped(entity)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        player.method_7322(0.1f);
        float high = 0.6f;
        if (CharmHelper.charmFleetingStridesEquipped(entity) && CharmHelper.charmCombinationFleetingStridesAndHighBoundsEnabled(entity)) {
            high += 0.05f;
        }
        if ((random = class_5819.method_43047()).method_43048(10) < 7) {
            ParticleHelper.spawnParticle(player, ModParticles.HIGH_BOUNDS_EFFECT_PARTICLE, player.method_23317() + (double)random.method_39332(-2, 2) / 10.0, player.method_23318(), player.method_23321() + (double)random.method_39332(-2, 2) / 10.0, random.method_39332(3, 5), 0.1, 0.0, 0.1, 0.07);
        }
        cir.setReturnValue((Object)Float.valueOf(entity.method_37416() + high));
    }

    @ModifyArg(method={"computeFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;ceil(F)I"), index=0)
    private float highBoundsEffectFall(float value) {
        class_1309 entity = (class_1309)this;
        if (!entity.method_31747()) {
            return value;
        }
        if (!CharmHelper.charmHighBoundsEquipped(entity)) {
            return value;
        }
        return value - 2.0f;
    }

    @Inject(method={"jump"}, at={@At(value="RETURN")})
    private void fleetingStridesHungerOnJump(CallbackInfo ci) {
        class_5819 random;
        class_1309 entity = (class_1309)this;
        if (!entity.method_31747()) {
            return;
        }
        if (!CharmHelper.charmFleetingStridesEquipped(entity)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (!player.method_5624() || player.method_31549().field_7479) {
            return;
        }
        float exhaustion = 0.1f;
        if (CharmHelper.charmHighBoundsEquipped((class_1309)player) && CharmHelper.charmCombinationFleetingStridesAndHighBoundsEnabled((class_1309)player)) {
            exhaustion += 0.05f;
        }
        if (CharmHelper.charmBattleFuryEquipped((class_1309)player) && CharmHelper.charmCombinationFleetingStridesAndBattleFuryEnabled((class_1309)player)) {
            exhaustion += (float)((double)0.1f * BattleFuryHelper.getMultiplier(player));
        }
        if ((random = class_5819.method_43047()).method_43048(10) < 7) {
            ParticleHelper.spawnParticle(player, ModParticles.FLEETING_STRIDES_EFFECT_PARTICLE, player.method_23317() + (double)random.method_39332(-2, 2) / 10.0, player.method_23318(), player.method_23321() + (double)random.method_39332(-2, 2) / 10.0, random.method_39332(3, 5), 0.1, 0.0, 0.1, 0.07);
        }
        player.method_7322(exhaustion);
    }

    @Inject(method={"getStepHeight"}, at={@At(value="RETURN")}, cancellable=true)
    private void climbersPathEffect(CallbackInfoReturnable<Float> cir) {
        class_1309 entity = (class_1309)this;
        if (!entity.method_31747()) {
            return;
        }
        if (!CharmHelper.charmClimbersPathEquipped(entity)) {
            return;
        }
        float height = 1.1f;
        if (CharmHelper.charmHighBoundsEquipped(entity) && CharmHelper.charmCombinationClimbersPathAndHighBoundsEnabled(entity)) {
            height += 0.5f;
        }
        class_1657 player = (class_1657)entity;
        class_5819 random = class_5819.method_43047();
        if (random.method_43048(10) < 1 && player.method_24828()) {
            ParticleHelper.spawnParticle(player, ModParticles.CLIMBERS_PATH_EFFECT_PARTICLE, player.method_23317() + (double)random.method_39332(-2, 2) / 10.0, player.method_23318(), player.method_23321() + (double)random.method_39332(-2, 2) / 10.0, 1, 0.1, 0.1, 0.1, 0.01);
        }
        cir.setReturnValue((Object)Float.valueOf(height));
    }

    @Inject(method={"takeKnockback"}, at={@At(value="HEAD")}, cancellable=true)
    private void mountainsStrengthEffectKnock(double strength, double x, double z, CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (!entity.method_31747()) {
            return;
        }
        if (!CharmHelper.charmMountainsStrengthEquipped(entity)) {
            return;
        }
        ci.cancel();
    }

    @Inject(method={"isPushable"}, at={@At(value="RETURN")}, cancellable=true)
    private void mountainsStrengthEffectPush(CallbackInfoReturnable<Boolean> cir) {
        class_1309 entity = (class_1309)this;
        if (!entity.method_31747()) {
            return;
        }
        if (!CharmHelper.charmMountainsStrengthEquipped(entity)) {
            return;
        }
        cir.setReturnValue((Object)false);
    }
}

