/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.integration.yacl;

import dev.isxander.yacl.api.Binding;
import dev.isxander.yacl.api.ConfigCategory;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.OptionGroup;
import dev.isxander.yacl.api.YetAnotherConfigLib;
import dev.isxander.yacl.gui.controllers.ColorController;
import dev.isxander.yacl.gui.controllers.LabelController;
import dev.isxander.yacl.gui.controllers.TickBoxController;
import dev.isxander.yacl.gui.controllers.cycling.EnumController;
import dev.isxander.yacl.gui.controllers.slider.DoubleSliderController;
import dev.isxander.yacl.gui.controllers.slider.IntegerSliderController;
import dev.isxander.yacl.gui.controllers.string.StringController;
import java.awt.Color;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.ConfigEntry;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.ConfigSubCategory;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.FabricConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.BoolConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.ColorConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.ConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.DoubleConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.EnumConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.IntConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.JsonConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.ListStringConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.ObjectConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.StringConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class YACLCompat {
    public static final Function<Double, class_2561> DOUBLE_FORMATTER = value -> class_2561.method_30163((String)String.format("%,.4f", value).replaceAll("[\u00a0\u202f]", " "));

    public static class_437 makeScreen(class_437 parent, FabricConfigSpec spec) {
        return YACLCompat.makeScreen(parent, spec, null);
    }

    public static class_437 makeScreen(class_437 parent, FabricConfigSpec spec, @Nullable class_2960 background) {
        spec.loadFromFile();
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder();
        builder.title(spec.getName());
        builder.save(spec::saveConfig);
        for (ConfigEntry en : spec.getMainEntry().getEntries()) {
            if (!(en instanceof ConfigSubCategory)) continue;
            ConfigSubCategory c = (ConfigSubCategory)en;
            ConfigCategory.Builder mainCat = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)c.getName()));
            for (ConfigEntry entry : c.getEntries()) {
                if (entry instanceof ConfigSubCategory) {
                    ConfigSubCategory subCat = (ConfigSubCategory)entry;
                    OptionGroup.Builder subBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)subCat.getName())).collapsed(true);
                    YACLCompat.addEntriesRecursive(mainCat, subBuilder, subCat);
                    mainCat.group(subBuilder.build());
                    continue;
                }
                mainCat.option(YACLCompat.buildEntry(entry));
            }
            builder.category(mainCat.build());
        }
        return builder.build().generateScreen(parent);
    }

    private static void addEntriesRecursive(ConfigCategory.Builder builder, OptionGroup.Builder subCategoryBuilder, ConfigSubCategory c) {
        for (ConfigEntry entry : c.getEntries()) {
            if (entry instanceof ConfigSubCategory) {
                ConfigSubCategory cc = (ConfigSubCategory)entry;
                OptionGroup.Builder scb = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)entry.getName())).tooltip(new class_2561[]{class_2561.method_43470((String)"Unsupported")});
                YACLCompat.addEntriesRecursive(builder, subCategoryBuilder, cc);
                continue;
            }
            subCategoryBuilder.option(YACLCompat.buildEntry(entry));
        }
    }

    private static Option<?> buildEntry(ConfigEntry entry) {
        if (entry instanceof ColorConfigValue) {
            ColorConfigValue col = (ColorConfigValue)entry;
            Option.Builder e = Option.createBuilder(Color.class).name(col.getTranslation()).binding((Object)new Color((Integer)col.getDefaultValue()), () -> new Color((Integer)col.get()), v -> col.set(v.getRGB())).controller(o -> new ColorController(o, true));
            class_2561 description = col.getDescription();
            if (description != null) {
                e.tooltip(new class_2561[]{description});
            }
            return e.build();
        }
        if (entry instanceof IntConfigValue) {
            IntConfigValue ic = (IntConfigValue)entry;
            Option.Builder e = Option.createBuilder(Integer.class).name(ic.getTranslation()).binding((Object)((Integer)ic.getDefaultValue()), (Supplier)ic, ic::set).controller(o -> new IntegerSliderController(o, ic.getMin().intValue(), ic.getMax().intValue(), 1));
            class_2561 description = ic.getDescription();
            if (description != null) {
                e.tooltip(new class_2561[]{description});
            }
            return e.build();
        }
        if (entry instanceof DoubleConfigValue) {
            DoubleConfigValue dc = (DoubleConfigValue)entry;
            Option.Builder e = Option.createBuilder(Double.class).name(dc.getTranslation()).binding((Object)((Double)dc.getDefaultValue()), (Supplier)dc, dc::set).controller(o -> new DoubleSliderController(o, dc.getMin().doubleValue(), dc.getMax().doubleValue(), 1.0E-4, DOUBLE_FORMATTER));
            class_2561 description = dc.getDescription();
            if (description != null) {
                e.tooltip(new class_2561[]{description});
            }
            return e.build();
        }
        if (entry instanceof StringConfigValue) {
            StringConfigValue sc = (StringConfigValue)entry;
            Option.Builder e = Option.createBuilder(String.class).name(sc.getTranslation()).binding((Object)((String)sc.getDefaultValue()), (Supplier)sc, sc::set).controller(StringController::new);
            class_2561 description = sc.getDescription();
            if (description != null) {
                e.tooltip(new class_2561[]{description});
            }
            return e.build();
        }
        if (entry instanceof BoolConfigValue) {
            BoolConfigValue bc = (BoolConfigValue)entry;
            Option.Builder e = Option.createBuilder(Boolean.class).name(bc.getTranslation()).binding((Object)((Boolean)bc.getDefaultValue()), (Supplier)bc, bc::set).controller(TickBoxController::new);
            class_2561 description = bc.getDescription();
            if (description != null) {
                e.tooltip(new class_2561[]{description});
            }
            return e.build();
        }
        if (entry instanceof EnumConfigValue) {
            EnumConfigValue ec = (EnumConfigValue)entry;
            return YACLCompat.addEnum(ec);
        }
        if (entry instanceof ListStringConfigValue) {
            ListStringConfigValue lc = (ListStringConfigValue)entry;
            Option.Builder e = Option.createBuilder(class_2561.class).name(lc.getTranslation()).binding(Binding.immutable((Object)class_2561.method_43470((String)"String Lists are not supported"))).controller(LabelController::new);
            class_2561 description = lc.getDescription();
            if (description != null) {
                e.tooltip(new class_2561[]{description});
            }
            return e.build();
        }
        if (entry instanceof JsonConfigValue || entry instanceof ObjectConfigValue) {
            ConfigValue lc = (ConfigValue)entry;
            Option.Builder e = Option.createBuilder(class_2561.class).name(lc.getTranslation()).binding(Binding.immutable((Object)class_2561.method_43470((String)"Object fields are not supported. Edit the config manually instead"))).controller(LabelController::new);
            class_2561 description = lc.getDescription();
            if (description != null) {
                e.tooltip(new class_2561[]{description});
            }
            return e.build();
        }
        throw new UnsupportedOperationException("unknown entry: " + entry.getClass().getName());
    }

    private static <T extends Enum<T>> Option<T> addEnum(EnumConfigValue<T> ec) {
        Option.Builder e = Option.createBuilder(ec.getEnumClass()).name(ec.getTranslation()).binding((Object)((Enum)ec.getDefaultValue()), ec, ec::set).controller(EnumController::new);
        class_2561 description = ec.getDescription();
        if (description != null) {
            e.tooltip(new class_2561[]{description});
        }
        return e.build();
    }
}

