/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.report;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.exception.AbortedException;
import com.bawnorton.neruina.exception.InProgressException;
import com.bawnorton.neruina.report.AutoReportConfig;
import com.bawnorton.neruina.report.GithubAuthManager;
import com.bawnorton.neruina.report.IssueFormatter;
import com.bawnorton.neruina.report.ReportStatus;
import com.bawnorton.neruina.report.RepositoryReference;
import com.bawnorton.neruina.util.TickingEntry;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Either;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public final class AutoReportHandler {
    private final Set<UUID> reportedEntries = Collections.synchronizedSet(new HashSet());
    private final List<AutoReportConfig> configs = new ArrayList<AutoReportConfig>();
    private final Map<String, RepositoryReference> repositories = new HashMap<String, RepositoryReference>();
    private AutoReportConfig masterConfig;

    public void init(MinecraftServer server) {
        Map neruinaAutoGhFiles = server.method_34864().method_14488("neruina", resource -> resource.method_12832().equals("neruina/auto_report.json"));
        for (Map.Entry entry : neruinaAutoGhFiles.entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            class_3298 resource2 = (class_3298)entry.getValue();
            try (JsonReader reader = new JsonReader((Reader)resource2.method_43039());){
                AutoReportConfig config = AutoReportConfig.fromJson(reader);
                if (config.isVaild()) {
                    if (id.method_12836().equals("neruina")) {
                        this.masterConfig = config;
                        continue;
                    }
                    Neruina.LOGGER.info("Auto report config loaded for mod: \"{}\"", (Object)config.modid());
                    this.configs.add(config);
                    continue;
                }
                Neruina.LOGGER.warn("Invalid auto report config found: {}, ignoring", (Object)id);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.masterConfig == null) {
            Neruina.LOGGER.warn("No master auto report config found, creating default");
            this.masterConfig = new AutoReportConfig("*", "Bawnorton/NeruinaAutoReports", null, null);
        }
    }

    public CompletableFuture<ReportStatus> createReports(class_3222 player, TickingEntry entry) {
        return this.createReports(player, entry, true);
    }

    public CompletableFuture<ReportStatus> createReports(class_3222 player, TickingEntry entry, boolean publish) {
        GHIssueBuilder masterIssueBuilder;
        UUID entryId = entry.uuid();
        if (this.reportedEntries.contains(entryId)) {
            return CompletableFuture.completedFuture(ReportStatus.alreadyExists());
        }
        Either result = (Either)((CompletableFuture)((CompletableFuture)GithubAuthManager.getOrLogin(player).thenApply(Either::left)).exceptionally(throwable -> {
            Throwable cause = throwable.getCause();
            if (cause instanceof InProgressException) {
                return Either.right((Object)ReportStatus.inProgress());
            }
            if (cause instanceof CancellationException) {
                return Either.right((Object)ReportStatus.timeout());
            }
            if (cause instanceof AbortedException) {
                return Either.right((Object)ReportStatus.aborted());
            }
            Neruina.LOGGER.error("Failed to create report(s)", throwable);
            return Either.right((Object)ReportStatus.failure());
        })).join();
        if (result.right().isPresent()) {
            return CompletableFuture.completedFuture((ReportStatus)result.right().orElseThrow());
        }
        GitHub github = (GitHub)result.left().orElseThrow();
        this.reportedEntries.add(entryId);
        Set<String> modids = entry.findPotentialSources();
        HashMap<String, @Nullable GHIssueBuilder> issueBuilders = new HashMap<String, GHIssueBuilder>();
        for (String modid : modids) {
            issueBuilders.put(modid, null);
            RepositoryReference repository = this.repositories.computeIfAbsent(modid, key -> {
                for (AutoReportConfig config : this.configs) {
                    String listeningModid = config.modid();
                    if (!listeningModid.equals("*") && !listeningModid.equals(modid)) continue;
                    try {
                        GHRepository ghRepository = github.getRepository(config.repo());
                        return new RepositoryReference(modid, ghRepository, config);
                    }
                    catch (IOException e) {
                        Neruina.LOGGER.error("Failed to get repository for mod: \"{}\", report this to them.", (Object)modid, (Object)e);
                    }
                }
                return null;
            });
            if (repository == null) continue;
            try {
                GHIssueBuilder issue = this.createIssue(github, repository, entry);
                issueBuilders.put(modid, issue);
            }
            catch (RuntimeException e) {
                Neruina.LOGGER.error("Failed to create issue for mod: \"{}\"", (Object)modid, (Object)e);
                return CompletableFuture.completedFuture(ReportStatus.failure());
            }
        }
        HashMap<String, GHIssue> builtIssues = new HashMap<String, GHIssue>();
        if (publish) {
            issueBuilders.forEach((s, ghIssueBuilder) -> {
                if (ghIssueBuilder == null) {
                    return;
                }
                try {
                    builtIssues.put((String)s, ghIssueBuilder.create());
                }
                catch (IOException e) {
                    Neruina.LOGGER.error("Failed to create issue for mod: \"{}\"", s, (Object)e);
                }
            });
        }
        try {
            masterIssueBuilder = this.createMasterIssue(github, builtIssues, entry);
        }
        catch (RuntimeException e) {
            Neruina.LOGGER.error("Failed to create master issue", (Throwable)e);
            return CompletableFuture.completedFuture(ReportStatus.failure());
        }
        if (masterIssueBuilder == null) {
            return CompletableFuture.completedFuture(ReportStatus.failure());
        }
        try {
            if (publish) {
                GHIssue masterIssue = masterIssueBuilder.create();
                String url = masterIssue.getHtmlUrl().toString();
                Neruina.LOGGER.info("Report(s) created for ticking entry: ({}: {})", (Object)entry.getCauseType(), (Object)entry.getCauseName());
                return CompletableFuture.completedFuture(ReportStatus.success(url));
            }
            return CompletableFuture.completedFuture(ReportStatus.testing());
        }
        catch (IOException e) {
            Neruina.LOGGER.error("Failed to create master issue", (Throwable)e);
            return CompletableFuture.completedFuture(ReportStatus.failure());
        }
    }

    private GHIssueBuilder createMasterIssue(GitHub github, Map<String, GHIssue> issueMap, TickingEntry tickingEntry) {
        if (this.masterConfig == null) {
            return null;
        }
        RepositoryReference masterRepo = this.repositories.computeIfAbsent("neruina", key -> {
            try {
                GHRepository ghRepository = github.getRepository(this.masterConfig.repo());
                return new RepositoryReference("neruina", ghRepository, this.masterConfig);
            }
            catch (IOException e) {
                return null;
            }
        });
        if (masterRepo == null) {
            return null;
        }
        IssueFormatter formatter = this.masterConfig.createIssueFormatter();
        String body = "%s".formatted(formatter.getBody(tickingEntry, github));
        if (!issueMap.isEmpty()) {
            body = "## Associated Issues:\n%s\n\n%s\n".formatted(issueMap.entrySet().stream().map(entry -> {
                String modid = (String)entry.getKey();
                GHIssue issue = (GHIssue)entry.getValue();
                if (issue == null) {
                    return "- %s: Not opted into auto-reporting".formatted(modid);
                }
                return "- [%s](%s)".formatted(modid, issue.getHtmlUrl().toString());
            }).collect(Collectors.joining("\n")), body);
        }
        return masterRepo.createIssueBuilder(formatter.getTitle(tickingEntry)).body(body);
    }

    private GHIssueBuilder createIssue(GitHub github, RepositoryReference reference, TickingEntry entry) {
        AutoReportConfig config = reference.config();
        IssueFormatter formatter = config.createIssueFormatter();
        return reference.createIssueBuilder(formatter.getTitle(entry)).body(formatter.getBody(entry, github));
    }

    public void testReporting(class_3222 player) {
        TickingEntry dummyEntry = new TickingEntry(player, false, (class_5321<class_1937>)player.method_37908().method_27983(), player.method_24515(), new RuntimeException());
        this.createReports(player, dummyEntry, false);
    }
}

