/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivearmorhud.foundation.config;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import toni.immersivearmorhud.foundation.config.CClient;
import toni.lib.config.ConfigBase;
import toni.lib.utils.PlatformUtils;

public class AllConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    private static CClient client;

    public static CClient client() {
        return client;
    }

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register(BiConsumer<ModConfig.Type, ForgeConfigSpec> registration) {
        if (!PlatformUtils.isDedicatedServer()) {
            client = AllConfigs.register(CClient::new, ModConfig.Type.CLIENT);
        }
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            registration.accept(pair.getKey(), pair.getValue().specification);
        }
    }

    public static void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        HashSet<String> existing = new HashSet<String>();
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            AllConfigs.addEntrySetTranslations(existing, pair.getValue().specification.getSpec().entrySet(), translationBuilder);
        }
    }

    public static void addEntrySetTranslations(HashSet<String> existing, Set<? extends UnmodifiableConfig.Entry> config, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (UnmodifiableConfig.Entry entry : config) {
            Object object;
            if (existing.add(entry.getKey())) {
                translationBuilder.add("immersivearmorhud.configuration." + entry.getKey(), entry.getKey());
            }
            if (!((object = entry.getValue()) instanceof AbstractConfig)) continue;
            AbstractConfig children = (AbstractConfig)object;
            AllConfigs.addEntrySetTranslations(existing, children.entrySet(), translationBuilder);
        }
    }
}

