/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivearmorhud;

import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import toni.immersivearmorhud.foundation.config.AllConfigs;
import toni.lib.utils.ColorUtils;
import toni.lib.utils.VersionUtils;

public class ArmorBarRenderer {
    public static final class_1304[] ARMOR_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    public static Map<String, String> configuredPrefixes = Map.ofEntries(Map.entry("minecraft:diamond", "diamond"), Map.entry("betterend:thallasium", "diamond"), Map.entry("betterend:terminite", "diamond"), Map.entry("deeperdarker:resonarium", "diamond"), Map.entry("minecraft:netherite", "netherite"), Map.entry("minecraft:iron", "iron"), Map.entry("minecraft:chainmail", "iron"), Map.entry("minecraft:gold", "gold"), Map.entry("minecraft:leather", "leather"), Map.entry("minecraft:elytra", "elytra"), Map.entry("aether:zanite", "zanite"), Map.entry("aether:gravitite", "gravitite"), Map.entry("aether:phoenix", "phoenix"), Map.entry("aether:neptune", "neptune"), Map.entry("aether:valkyrie", "valkyrie"), Map.entry("aether:obsidian", "obsidian"));

    private static class_2960 getTextureForItem(class_1792 item) {
        String itemID = class_7923.field_41178.method_10221((Object)item).toString();
        String path = "iron";
        for (Map.Entry<String, String> prefix : configuredPrefixes.entrySet()) {
            if (!itemID.contains(prefix.getKey())) continue;
            path = prefix.getValue();
            break;
        }
        return VersionUtils.resource((String)"immersivearmorhud", (String)("textures/gui/sprites/" + path + ".png"));
    }

    private static float getDurabilityPercentage(class_1799 stack) {
        int maxDurability = ArmorBarRenderer.getMaxDamage(stack.method_7909(), stack);
        int currentDurability = stack.method_7919();
        return 1.0f - (float)currentDurability / (float)maxDurability;
    }

    private static int getMaxDamage(class_1792 item, class_1799 stack) {
        return item.method_7841();
    }

    private static int getDurabilityColor(float durability) {
        if ((double)durability > 0.51) {
            return ColorUtils.color((int)0, (int)255, (int)0);
        }
        if ((double)durability > 0.25) {
            return ColorUtils.color((int)255, (int)165, (int)0);
        }
        return ColorUtils.color((int)255, (int)0, (int)0);
    }

    public static boolean render(class_332 graphics, int vanillaHeight) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        class_638 level = client.field_1687;
        if (player == null || level == null) {
            return false;
        }
        boolean rightAligned = (Boolean)AllConfigs.client().rightAligned.get();
        int yOffset = (Integer)AllConfigs.client().yOffset.get();
        int xOffset = (Integer)AllConfigs.client().xOffset.get();
        int screenWidth = graphics.method_51421();
        int slotOffset = 0;
        boolean flag = false;
        for (int i = 0; i < ARMOR_SLOTS.length; ++i) {
            class_1304 slot = ARMOR_SLOTS[i];
            class_1799 stack = player.method_6118(slot);
            if (stack.method_7960()) continue;
            flag = true;
            int u = i * 8;
            int x = (rightAligned ? 149 : 0) + xOffset + screenWidth / 2 - 91 + slotOffset * 8;
            int y = yOffset + vanillaHeight;
            graphics.method_25293(ArmorBarRenderer.getTextureForItem(stack.method_7909()), x, y, 8, 8, (float)u, 0.0f, 8, 8, 33, 9);
            float durability = ArmorBarRenderer.getDurabilityPercentage(stack);
            if (durability < 0.5f) {
                int barWidth = (int)(6.0f * durability);
                int color = ArmorBarRenderer.getDurabilityColor(durability);
                graphics.method_25294(x + 1, y + 7, x + 8, y + 8, ColorUtils.color((int)0, (int)0, (int)0));
                graphics.method_25294(x + 1, y + 7, x + 2 + barWidth, y + 8, color);
            }
            ++slotOffset;
        }
        return flag;
    }
}

