/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.abridged.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.abridged.config.ConfigHandler;
import dev.worldgen.abridged.registry.AbridgedRegistries;
import dev.worldgen.abridged.worldgen.structure.BridgeConfig;
import dev.worldgen.abridged.worldgen.structure.BridgePiece;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3481;
import net.minecraft.class_3485;
import net.minecraft.class_3754;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6624;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7151;

public class BridgeStructure
extends class_3195 {
    public static final MapCodec<BridgeStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BridgeStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)Codec.INT.fieldOf("max_chunk_radius").forGetter(BridgeStructure::maxChunkRadius)).apply((Applicative)instance, BridgeStructure::new));
    private final int maxChunkRadius;

    protected BridgeStructure(class_3195.class_7302 baseSettings, int maxChunkRadius) {
        super(baseSettings);
        this.maxChunkRadius = maxChunkRadius;
    }

    public int maxChunkRadius() {
        return this.maxChunkRadius;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (context.comp_566().method_43057() > ConfigHandler.state().frequency) {
            return Optional.empty();
        }
        class_2338 origin = new class_2338(context.comp_568().method_33940(), 90, context.comp_568().method_33942());
        Heightmaps heightmaps = this.buildHeightmapData(context, origin);
        List configs = context.comp_561().method_46762(AbridgedRegistries.BRIDGE_CONFIG_KEY).method_42017().toList();
        IntArrayList indices = class_156.method_43251((IntStream)IntStream.rangeClosed(0, configs.size() - 1), (class_5819)context.comp_566());
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            class_6880 config = (class_6880)configs.get(index);
            BridgeData bridgeData = this.getBridgeData(context, origin, heightmaps, (BridgeConfig)config.comp_349());
            if (bridgeData == null) continue;
            class_2338 pos = new class_2338(context.comp_568().method_33940(), bridgeData.getHeight().intValue(), context.comp_568().method_33942());
            return BridgeStructure.method_41612((class_3195.class_7149)context, (class_2902.class_2903)class_2902.class_2903.field_13195, collector -> BridgeStructure.addPieces(context.comp_565(), (class_5819)context.comp_566(), pos, (class_6130)collector, bridgeData, (class_6880<BridgeConfig>)config));
        }
        return Optional.empty();
    }

    private BridgeData getBridgeData(class_3195.class_7149 context, class_2338 pos, Heightmaps heightmaps, BridgeConfig config) {
        if (!config.condition().test(context, pos)) {
            return null;
        }
        BridgeData xBridgeData = this.findValidSegmentLayout(class_2350.field_11034, heightmaps, config);
        return xBridgeData != null ? xBridgeData : this.findValidSegmentLayout(class_2350.field_11035, heightmaps, config);
    }

    private BridgeData findValidSegmentLayout(class_2350 direction, Heightmaps heightmaps, BridgeConfig config) {
        List<Integer> leftHeights = heightmaps.heights().get(direction.method_10153());
        List<Integer> rightHeights = heightmaps.heights().get(direction);
        Integer negativeHeight = null;
        Integer positiveHeight = null;
        Integer chunkOffset = null;
        Integer totalSegments = null;
        block0: for (int k = 0; k < leftHeights.size(); ++k) {
            Integer leftHeight = leftHeights.get(k);
            if (!config.height().method_37955((Comparable)leftHeight)) continue;
            for (int l = 0; l < rightHeights.size(); ++l) {
                Integer rightHeight = rightHeights.get(l);
                if (!config.height().method_37955((Comparable)rightHeight)) continue;
                int segments = k + l + 2;
                if (Math.abs(leftHeight - rightHeight) > config.maxHeightDifference() || !config.segments().method_37955((Comparable)Integer.valueOf(segments))) continue;
                negativeHeight = leftHeight;
                positiveHeight = rightHeight;
                chunkOffset = -k - 1;
                totalSegments = segments;
                break block0;
            }
        }
        if (negativeHeight == null) {
            return null;
        }
        return new BridgeData(negativeHeight, positiveHeight, chunkOffset, totalSegments, direction);
    }

    private Heightmaps buildHeightmapData(class_3195.class_7149 context, class_2338 pos) {
        return new Heightmaps(new EnumMap<class_2350, List<Integer>>(Map.of(class_2350.field_11043, this.buildHeightmapList(context, pos, class_2350.field_11043), class_2350.field_11034, this.buildHeightmapList(context, pos, class_2350.field_11034), class_2350.field_11035, this.buildHeightmapList(context, pos, class_2350.field_11035), class_2350.field_11039, this.buildHeightmapList(context, pos, class_2350.field_11039))));
    }

    private List<Integer> buildHeightmapList(class_3195.class_7149 context, class_2338 pos, class_2350 direction) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        for (int j = 1; j <= this.maxChunkRadius; ++j) {
            int height = BridgeStructure.getHeightmap(pos.method_10079(direction, 16 * j), context);
            if (j != 1 && (Integer)heights.get(heights.size() - 1) > height) break;
            heights.add(height);
        }
        return heights;
    }

    private static int getHeightmap(class_2338 pos, class_3195.class_7149 context) {
        class_2794 generator = context.comp_562();
        if (generator instanceof class_3754 && !ConfigHandler.state().directlySampleHeightmap) {
            double depthAtSeaLevel = context.comp_564().method_42370().comp_424().method_40464((class_6910.class_6912)new class_6910.class_6914(pos.method_10263(), 64, pos.method_10260()));
            return (int)((depthAtSeaLevel + 0.5) * 128.0) + 2;
        }
        return generator.method_20402(pos.method_10263(), pos.method_10260(), class_2902.class_2903.field_13195, context.comp_569(), context.comp_564());
    }

    public static void addPieces(class_3485 manager, class_5819 random, class_2338 pos, class_6130 pieceAccessor, BridgeData bridgeData, class_6880<BridgeConfig> holder) {
        BridgeConfig config = (BridgeConfig)holder.comp_349();
        for (int i = 0; i < bridgeData.totalSegments(); ++i) {
            if (i == 0) {
                pieceAccessor.method_35462((class_3443)new BridgePiece(manager, BridgeStructure.getId(config.edge(), random), pos.method_10079(bridgeData.direction(), (bridgeData.chunkOffset() + i) * 16), bridgeData.getRotation(), holder));
                continue;
            }
            if (i == bridgeData.totalSegments() - 1) {
                pieceAccessor.method_35462((class_3443)new BridgePiece(manager, BridgeStructure.getId(config.edge(), random), pos.method_10079(bridgeData.direction(), (bridgeData.chunkOffset() + i) * 16 + 15), bridgeData.getRotation(), class_2415.field_11301, holder));
                continue;
            }
            pieceAccessor.method_35462((class_3443)new BridgePiece(manager, BridgeStructure.getId(config.base(), random), pos.method_10079(bridgeData.direction(), (bridgeData.chunkOffset() + i) * 16), bridgeData.getRotation(), holder));
        }
        pieceAccessor.method_35462((class_3443)new BridgePiece(manager, BridgePiece.BEARD_BASE, pos.method_10079(bridgeData.direction(), bridgeData.chunkOffset() * 16).method_10079(class_2350.field_11033, -1), bridgeData.getRotation(), holder));
        pieceAccessor.method_35462((class_3443)new BridgePiece(manager, BridgePiece.BEARD_BASE, pos.method_10079(bridgeData.direction(), (bridgeData.chunkOffset() + bridgeData.totalSegments()) * 16 - 8).method_10079(class_2350.field_11033, -1), bridgeData.getRotation(), holder));
    }

    private static class_2960 getId(List<class_2960> ids, class_5819 random) {
        return (class_2960)class_156.method_32309(ids, (class_5819)random);
    }

    public void method_38694(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 box, class_1923 chunkPos, class_6624 piecesContainer) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        int minY = world.method_8597().comp_651();
        class_3341 blockBox = piecesContainer.method_38712();
        int baseY = blockBox.method_35416();
        List pieces = piecesContainer.comp_132();
        if (pieces.isEmpty() || !(pieces.get(0) instanceof BridgePiece)) {
            return;
        }
        class_2960 configId = ((BridgePiece)((Object)pieces.get((int)0))).configId;
        Optional config = world.method_30349().method_46762(AbridgedRegistries.BRIDGE_CONFIG_KEY).method_46746(class_5321.method_29179(AbridgedRegistries.BRIDGE_CONFIG_KEY, (class_2960)configId));
        if (config.isEmpty()) {
            return;
        }
        for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
            for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                pos.method_10103(x, baseY, z);
                class_2680 state = world.method_8320((class_2338)pos);
                block2: for (BridgeConfig.Extension extension : ((BridgeConfig)((class_6880.class_6883)config.get()).comp_349()).extensions()) {
                    if (!state.method_40143(extension.blocks()) || !blockBox.method_14662((class_2382)pos) || !piecesContainer.method_38710((class_2338)pos)) continue;
                    for (int y = baseY - 1; y > minY; --y) {
                        pos.method_33098(y);
                        if (!world.method_22347((class_2338)pos) && !world.method_8320((class_2338)pos).method_51176() && !world.method_8320((class_2338)pos).method_26164(class_3481.field_29822)) continue block2;
                        world.method_8652((class_2338)pos, extension.extendedState().method_23455(random, (class_2338)pos), 3);
                    }
                }
            }
        }
    }

    public class_7151<?> method_41618() {
        return AbridgedRegistries.BRIDGE_STRUCTURE;
    }

    public record Heightmaps(EnumMap<class_2350, List<Integer>> heights) {
    }

    public record BridgeData(Integer leftHeight, Integer rightHeight, Integer chunkOffset, Integer totalSegments, class_2350 direction) {
        public class_2470 getRotation() {
            return this.direction.method_10166() == class_2350.class_2351.field_11048 ? class_2470.field_11467 : class_2470.field_11463;
        }

        public Integer getHeight() {
            return Math.min(this.leftHeight, this.rightHeight);
        }
    }
}

