/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.BWGCustomStructureProcessors;
import org.jetbrains.annotations.NotNull;

public class PlantProcessor
extends StructureProcessor {
    public static final Codec<PlantProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("ground").forGetter(processor -> processor.ground), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("plant").forGetter(processor -> processor.plant), (App)Codec.FLOAT.fieldOf("chance").forGetter(processor -> Float.valueOf(processor.chance))).apply((Applicative)instance, PlantProcessor::new));
    private final Block ground;
    private final Block plant;
    private final IntegerProperty ageProperty;
    private final float chance;

    public PlantProcessor(Block ground, Block plant, float chance) {
        this(ground, plant, (IntegerProperty)plant.m_49966_().m_61147_().stream().filter(property -> property.m_61708_().equals("age")).findFirst().get(), chance);
    }

    private PlantProcessor(Block ground, Block plant, IntegerProperty AgeProperty, float chance) {
        this.ground = ground;
        this.plant = plant;
        this.ageProperty = AgeProperty;
        this.chance = chance;
    }

    @NotNull
    public List<StructureTemplate.StructureBlockInfo> m_276976_(@NotNull ServerLevelAccessor serverLevel, @NotNull BlockPos offset, @NotNull BlockPos pos, @NotNull List<StructureTemplate.StructureBlockInfo> originalBlockInfos, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlockInfos, @NotNull StructurePlaceSettings settings) {
        ArrayList<StructureTemplate.StructureBlockInfo> newInfo = new ArrayList<StructureTemplate.StructureBlockInfo>(List.copyOf(processedBlockInfos));
        processedBlockInfos.stream().filter(structureBlockInfo -> structureBlockInfo.f_74676_().m_60713_(this.ground)).forEach(block -> {
            BlockPos belowPos = block.f_74675_();
            newInfo.stream().filter(structureBlockInfo -> structureBlockInfo.f_74675_().equals((Object)belowPos.m_7494_())).findFirst().ifPresent(spot -> {
                if (spot.f_74676_().m_60795_() && serverLevel.m_213780_().m_188501_() < this.chance) {
                    newInfo.remove(spot);
                    newInfo.add(new StructureTemplate.StructureBlockInfo(spot.f_74675_(), (BlockState)this.plant.m_49966_().m_61124_((Property)this.ageProperty, (Comparable)Integer.valueOf(settings.m_230326_(spot.f_74675_()).m_188503_(this.ageProperty.m_6908_().size()))), spot.f_74677_()));
                }
            });
        });
        return newInfo;
    }

    @NotNull
    protected StructureProcessorType<?> m_6953_() {
        return BWGCustomStructureProcessors.PLANT_PROCESSOR.get();
    }
}

