/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.world.level.levelgen.CheckedBlockPlacement;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructurePieceTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.arch.ArchConfig;
import org.jetbrains.annotations.NotNull;

public class ArchPiece
extends StructurePiece {
    private final BlockPos origin;
    private final BlockPos first;
    private final BlockPos second;
    private final int yOffset;
    private final ArchConfig.ArchGeneratorConfig generatorConfig;
    private final CheckedBlockPlacement blockPlacement;

    protected ArchPiece(BoundingBox boundingBox, BlockPos origin, BlockPos first, BlockPos second, int yOffset, ArchConfig.ArchGeneratorConfig generatorConfig, CheckedBlockPlacement blockPlacement) {
        super(BWGStructurePieceTypes.ARCH_PIECE.get(), 0, boundingBox);
        this.origin = origin;
        this.first = first;
        this.second = second;
        this.yOffset = yOffset;
        this.generatorConfig = generatorConfig;
        this.blockPlacement = blockPlacement;
    }

    public ArchPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BWGStructurePieceTypes.ARCH_PIECE.get(), tag);
        this.origin = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("origin"));
        this.first = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("first"));
        this.second = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("second"));
        this.yOffset = tag.m_128451_("yOffset");
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)context.f_192763_());
        this.generatorConfig = (ArchConfig.ArchGeneratorConfig)((Pair)ArchConfig.ArchGeneratorConfig.CODEC.decode((DynamicOps)ops, (Object)tag.m_128469_("generatorConfig")).result().orElseThrow()).getFirst();
        this.blockPlacement = (CheckedBlockPlacement)((Pair)CheckedBlockPlacement.CODEC.decode((DynamicOps)ops, (Object)tag.m_128423_("blockPlacements")).result().orElseThrow()).getFirst();
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128365_("origin", (Tag)NbtUtils.m_129224_((BlockPos)this.origin));
        tag.m_128365_("first", (Tag)NbtUtils.m_129224_((BlockPos)this.first));
        tag.m_128365_("second", (Tag)NbtUtils.m_129224_((BlockPos)this.second));
        tag.m_128405_("yOffset", this.yOffset);
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)context.f_192763_());
        tag.m_128365_("generatorConfig", (Tag)ArchConfig.ArchGeneratorConfig.CODEC.encodeStart((DynamicOps)ops, (Object)this.generatorConfig).result().orElseThrow());
        tag.m_128365_("blockPlacements", (Tag)CheckedBlockPlacement.CODEC.encodeStart((DynamicOps)ops, (Object)this.blockPlacement).result().orElseThrow());
    }

    public void m_213694_(WorldGenLevel level, @NotNull StructureManager structureManager, @NotNull ChunkGenerator generator, @NotNull RandomSource random, @NotNull BoundingBox box, ChunkPos chunkPos, @NotNull BlockPos pos) {
        ChunkAccess chunk = level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        LongOpenHashSet cache = new LongOpenHashSet();
        Consumer<BlockPos> blockPosConsumer = arg_0 -> this.lambda$postProcess$0((LongSet)cache, arg_0);
        this.generatorConfig.generate(this.origin.m_121878_() + level.m_7328_(), this.yOffset, Vec3.m_82512_((Vec3i)this.first), Vec3.m_82512_((Vec3i)this.origin), Vec3.m_82512_((Vec3i)this.second), this.f_73383_, blockPosConsumer);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pair<BlockPredicate, BlockStateProvider> blockPlacement : this.blockPlacement.blockPlacement()) {
            cache.forEach(packedPos -> {
                mutableBlockPos.m_122188_(packedPos);
                if (((BlockPredicate)blockPlacement.getFirst()).test((Object)level, (Object)mutableBlockPos)) {
                    chunk.m_6978_((BlockPos)mutableBlockPos, ((BlockStateProvider)blockPlacement.getSecond()).m_213972_(random, (BlockPos)mutableBlockPos), false);
                }
            });
        }
    }

    private /* synthetic */ void lambda$postProcess$0(LongSet cache, BlockPos blockPos) {
        if (this.f_73383_.m_71051_((Vec3i)blockPos)) {
            cache.add(blockPos.m_121878_());
        }
    }
}

