/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.forge;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.commands.BWGCommands;
import net.potionstudios.biomeswevegone.forge.ForgePlatformHandler;
import net.potionstudios.biomeswevegone.forge.VanillaCompatForge;
import net.potionstudios.biomeswevegone.forge.client.BiomesWeveGoneClientForge;
import net.potionstudios.biomeswevegone.forge.loot.LootModifiersRegister;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerTrades;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGOverworldSurfaceRules;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGTerraBlenderRegion;
import software.bernie.geckolib.GeckoLib;
import terrablender.api.SurfaceRuleManager;

@Mod(value="biomeswevegone")
public class BiomesWeveGoneForge {
    public BiomesWeveGoneForge(FMLJavaModLoadingContext context) {
        IEventBus MOD_BUS = context.getModEventBus();
        IEventBus EVENT_BUS = MinecraftForge.EVENT_BUS;
        BiomesWeveGone.init();
        ForgePlatformHandler.register(MOD_BUS);
        MOD_BUS.addListener(this::onInitialize);
        MOD_BUS.addListener(this::onPostInitialize);
        EVENT_BUS.addListener(event -> BiomesWeveGone.serverStart(event.getServer()));
        MOD_BUS.addListener(event -> BWGEntityType.registerEntityAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1)));
        MOD_BUS.addListener(event -> BWGEntityType.registerSpawnPlacements(consumer -> event.register(consumer.entityType(), consumer.spawnPlacementType(), consumer.heightmapType(), consumer.predicate(), SpawnPlacementRegisterEvent.Operation.OR)));
        EVENT_BUS.addListener(event -> BWGCommands.register(arg_0 -> ((CommandDispatcher)event.getDispatcher()).register(arg_0)));
        EVENT_BUS.addListener(event -> BiomesWeveGone.onEntityLoad(event.getEntity()));
        VanillaCompatForge.registerVanillaCompatEvents(EVENT_BUS);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BiomesWeveGoneClientForge.init(MOD_BUS));
        GeckoLib.initialize();
        LootModifiersRegister.register(MOD_BUS);
    }

    private void onInitialize(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BiomesWeveGone.commonSetup();
            VanillaCompatForge.init();
            BWGTerraBlenderRegion.registerTerrablenderRegions();
            ForgePlatformHandler.registerPottedPlants();
            SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"biomeswevegone", (SurfaceRules.RuleSource)BWGOverworldSurfaceRules.makeRules());
        });
    }

    private void onPostInitialize(FMLLoadCompleteEvent event) {
        event.enqueueWork(BiomesWeveGone::postInit);
        BWGVillagerTrades.makeTrades();
        BWGVillagerTrades.makeWanderingTrades();
    }
}

