/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.integration.jei;

import com.teamabnormals.caverns_and_chasms.core.other.CCTiers;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBlocks;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import com.teamabnormals.caverns_and_chasms.integration.jei.ToolboxWaxingRecipeMaker;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class CCPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("caverns_and_chasms", "caverns_and_chasms");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CCBlocks.CUPRIC_CAMPFIRE.get()), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)CCItems.TETHER_POTION.get(), (itemStack, context) -> {
            if (!itemStack.m_41782_()) {
                return "";
            }
            Potion potionType = PotionUtils.m_43579_((ItemStack)itemStack);
            String potionTypeString = potionType.m_43492_("");
            StringBuilder stringBuilder = new StringBuilder(potionTypeString);
            List effects = PotionUtils.m_43547_((ItemStack)itemStack);
            for (MobEffectInstance effect : effects) {
                stringBuilder.append(";").append(effect);
            }
            return stringBuilder.toString();
        });
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.ANVIL, CCPlugin.getRepairRecipes(registration.getVanillaRecipeFactory()).toList());
        registration.addRecipes(RecipeTypes.CRAFTING, ToolboxWaxingRecipeMaker.createRecipes());
    }

    private static Stream<RepairData> getRepairData() {
        return Stream.of(new RepairData(CCTiers.CCArmorMaterials.SANGUINE.m_6230_(), new ItemStack((ItemLike)CCItems.SANGUINE_HELMET.get()), new ItemStack((ItemLike)CCItems.SANGUINE_CHESTPLATE.get()), new ItemStack((ItemLike)CCItems.SANGUINE_LEGGINGS.get()), new ItemStack((ItemLike)CCItems.SANGUINE_BOOTS.get())), new RepairData(CCTiers.CCItemTiers.SILVER.m_6282_(), new ItemStack((ItemLike)CCItems.SILVER_SWORD.get()), new ItemStack((ItemLike)CCItems.SILVER_PICKAXE.get()), new ItemStack((ItemLike)CCItems.SILVER_AXE.get()), new ItemStack((ItemLike)CCItems.SILVER_SHOVEL.get()), new ItemStack((ItemLike)CCItems.SILVER_HOE.get())), new RepairData(CCTiers.CCArmorMaterials.SILVER.m_6230_(), new ItemStack((ItemLike)CCItems.SILVER_HELMET.get()), new ItemStack((ItemLike)CCItems.SILVER_CHESTPLATE.get()), new ItemStack((ItemLike)CCItems.SILVER_LEGGINGS.get()), new ItemStack((ItemLike)CCItems.SILVER_BOOTS.get())), new RepairData(CCTiers.CCItemTiers.NECROMIUM.m_6282_(), new ItemStack((ItemLike)CCItems.NECROMIUM_SWORD.get()), new ItemStack((ItemLike)CCItems.NECROMIUM_AXE.get()), new ItemStack((ItemLike)CCItems.NECROMIUM_HOE.get()), new ItemStack((ItemLike)CCItems.NECROMIUM_SHOVEL.get()), new ItemStack((ItemLike)CCItems.NECROMIUM_PICKAXE.get())), new RepairData(CCTiers.CCArmorMaterials.NECROMIUM.m_6230_(), new ItemStack((ItemLike)CCItems.NECROMIUM_BOOTS.get()), new ItemStack((ItemLike)CCItems.NECROMIUM_HELMET.get()), new ItemStack((ItemLike)CCItems.NECROMIUM_LEGGINGS.get()), new ItemStack((ItemLike)CCItems.NECROMIUM_CHESTPLATE.get())));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        return CCPlugin.getRepairData().flatMap(repairData -> CCPlugin.getRepairRecipes(repairData, vanillaRecipeFactory));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(RepairData repairData, IVanillaRecipeFactory vanillaRecipeFactory) {
        Ingredient repairIngredient = repairData.getRepairIngredient();
        List<ItemStack> repairables = repairData.getRepairables();
        List<ItemStack> repairMaterials = List.of(repairIngredient.m_43908_());
        return repairables.stream().mapMulti((itemStack, consumer) -> {
            ItemStack damagedThreeQuarters = itemStack.m_41777_();
            damagedThreeQuarters.m_41721_(damagedThreeQuarters.m_41776_() * 3 / 4);
            ItemStack damagedHalf = itemStack.m_41777_();
            damagedHalf.m_41721_(damagedHalf.m_41776_() / 2);
            IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedThreeQuarters), List.of(damagedThreeQuarters), List.of(damagedHalf));
            consumer.accept(repairWithSame);
            if (!repairMaterials.isEmpty()) {
                ItemStack damagedFully = itemStack.m_41777_();
                damagedFully.m_41721_(damagedFully.m_41776_());
                IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, List.of(damagedThreeQuarters));
                consumer.accept(repairWithMaterial);
            }
        });
    }

    private static class RepairData {
        private final Ingredient repairIngredient;
        private final List<ItemStack> repairables;

        public RepairData(Ingredient repairIngredient, ItemStack ... repairables) {
            this.repairIngredient = repairIngredient;
            this.repairables = List.of(repairables);
        }

        public Ingredient getRepairIngredient() {
            return this.repairIngredient;
        }

        public List<ItemStack> getRepairables() {
            return this.repairables;
        }
    }
}

