/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.caverns_and_chasms.common.entity.monster.Mime;
import com.teamabnormals.caverns_and_chasms.common.item.TetherPotionItem;
import com.teamabnormals.caverns_and_chasms.core.other.CCTiers;
import com.teamabnormals.caverns_and_chasms.core.registry.CCTrimPatterns;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.armortrim.ArmorTrim;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class})
public abstract class HumanoidArmorLayerMixin<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    @Final
    @Shadow
    private A f_117072_;
    @Unique
    private static final ResourceLocation TETHER_POTION_LOCATION = new ResourceLocation("caverns_and_chasms", "textures/models/armor/tether_potion.png");
    @Unique
    private static final ResourceLocation TETHER_POTION_OVERLAY_LOCATION = new ResourceLocation("caverns_and_chasms", "textures/models/armor/tether_potion_overlay.png");

    @Shadow
    protected abstract void renderModel(PoseStack var1, MultiBufferSource var2, int var3, ArmorItem var4, Model var5, boolean var6, float var7, float var8, float var9, ResourceLocation var10);

    @Shadow
    protected abstract boolean m_117128_(EquipmentSlot var1);

    @Shadow
    protected abstract void renderTrim(ArmorMaterial var1, PoseStack var2, MultiBufferSource var3, int var4, ArmorTrim var5, Model var6, boolean var7);

    @Shadow
    protected abstract Model getArmorModelHook(T var1, ItemStack var2, EquipmentSlot var3, A var4);

    public HumanoidArmorLayerMixin(RenderLayerParent<T, M> entityRenderer) {
        super(entityRenderer);
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    public void render(PoseStack stack, MultiBufferSource source, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        this.renderWornTetherPotion(stack, source, packedLight, entity);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;setPartVisibility(Lnet/minecraft/client/model/HumanoidModel;Lnet/minecraft/world/entity/EquipmentSlot;)V", shift=At.Shift.BEFORE)}, method={"renderArmorPiece"})
    public void renderArmorPiece(PoseStack poseStack, MultiBufferSource source, T entity, EquipmentSlot slot, int num, A model, CallbackInfo ci) {
        if (entity instanceof Mime) {
            if (slot == EquipmentSlot.LEGS) {
                this.verticallyOffsetModelPart(((HumanoidModel)this.m_117386_()).f_102810_, ((HumanoidModel)model).f_102810_, 1.0f);
            } else if (slot == EquipmentSlot.FEET) {
                this.verticallyOffsetModelPart(((HumanoidModel)this.m_117386_()).f_102813_, ((HumanoidModel)model).f_102813_, 1.0f);
                this.verticallyOffsetModelPart(((HumanoidModel)this.m_117386_()).f_102814_, ((HumanoidModel)model).f_102814_, 1.0f);
            }
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hasFoil()Z", shift=At.Shift.BEFORE)}, method={"renderArmorPiece"})
    public void renderSanguineTrim(PoseStack poseStack, MultiBufferSource source, T entity, EquipmentSlot slot, int num, A model, CallbackInfo ci) {
        ArmorItem armorItem;
        ItemStack stack = entity.m_6844_(slot);
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40401_() == CCTiers.CCArmorMaterials.SANGUINE) {
            RegistryAccess access = entity.m_9236_().m_9598_();
            ArmorTrim.m_266285_((RegistryAccess)access, (ItemStack)stack).ifPresent(armorTrim -> {
                ArmorTrim trim = new ArmorTrim(armorTrim.m_266210_(), (Holder)access.m_175515_(Registries.f_266063_).m_246971_(CCTrimPatterns.SANGUINE));
                this.renderTrim(armorItem.m_40401_(), poseStack, source, num, trim, this.getArmorModelHook(entity, stack, slot, model), this.m_117128_(slot));
            });
        }
    }

    @Unique
    private void renderWornTetherPotion(PoseStack poseStack, MultiBufferSource source, int packedLight, T entity) {
        ItemStack stack = entity.m_6844_(EquipmentSlot.HEAD);
        if (stack.m_41720_() instanceof TetherPotionItem) {
            ((HumanoidModel)this.m_117386_()).m_102872_(this.f_117072_);
            this.f_117072_.m_8009_(false);
            ((HumanoidModel)this.f_117072_).f_102808_.f_104207_ = true;
            ((HumanoidModel)this.f_117072_).f_102809_.f_104207_ = true;
            boolean flag = stack.m_41790_();
            int i = PotionUtils.m_43575_((ItemStack)stack);
            float r = (float)(i >> 16 & 0xFF) / 255.0f;
            float g = (float)(i >> 8 & 0xFF) / 255.0f;
            float b = (float)(i & 0xFF) / 255.0f;
            this.renderModel(poseStack, source, packedLight, null, (Model)this.f_117072_, flag, r, g, b, TETHER_POTION_LOCATION);
            this.renderModel(poseStack, source, packedLight, null, (Model)this.f_117072_, flag, 1.0f, 1.0f, 1.0f, TETHER_POTION_OVERLAY_LOCATION);
        }
    }

    @Unique
    private void verticallyOffsetModelPart(ModelPart parentModelPart, ModelPart modelPart, float offset) {
        float yaw = parentModelPart.f_104203_;
        float pitch = parentModelPart.f_104204_;
        float roll = parentModelPart.f_104205_;
        modelPart.f_104200_ += (Mth.m_14031_((float)yaw) * Mth.m_14031_((float)pitch) * Mth.m_14089_((float)roll) - Mth.m_14089_((float)yaw) * Mth.m_14031_((float)roll)) * offset;
        modelPart.f_104201_ += (Mth.m_14031_((float)yaw) * Mth.m_14031_((float)pitch) * Mth.m_14031_((float)roll) + Mth.m_14089_((float)yaw) * Mth.m_14089_((float)roll)) * offset;
        modelPart.f_104202_ += Mth.m_14031_((float)yaw) * Mth.m_14089_((float)pitch) * offset;
    }
}

