/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.pumpjack;

import com.jesz.createdieselgenerators.CDGPartialModels;
import com.jesz.createdieselgenerators.content.pumpjack.PumpjackBearingBlockEntity;
import com.jesz.createdieselgenerators.content.pumpjack.PumpjackCrankBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class PumpjackCrankInstance
extends KineticBlockEntityVisual<PumpjackCrankBlockEntity>
implements SimpleDynamicVisual {
    protected final TransformedInstance crank = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CDGPartialModels.PUMPJACK_CRANK_SMALL)).createInstance();
    protected final TransformedInstance crank_rod = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CDGPartialModels.PUMPJACK_CRANK_ROD_SMALL)).createInstance();
    protected final TransformedInstance large_crank = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CDGPartialModels.PUMPJACK_CRANK_LARGE)).createInstance();
    protected final TransformedInstance large_crank_rod = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CDGPartialModels.PUMPJACK_CRANK_ROD_LARGE)).createInstance();
    protected final RotatingInstance shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstance();

    public PumpjackCrankInstance(VisualizationContext context, PumpjackCrankBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        this.shaft.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.UP, ((Direction)blockEntity.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122424_()).setChanged();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float partialTicks = ctx.partialTick();
        BlockState blockState = ((PumpjackCrankBlockEntity)this.blockEntity).m_58900_();
        BlockPos pos = ((PumpjackCrankBlockEntity)this.blockEntity).m_58899_();
        float angle = AngleHelper.angleLerp((double)partialTicks, (double)((PumpjackCrankBlockEntity)this.blockEntity).prevAngle, (double)((PumpjackCrankBlockEntity)this.blockEntity).angle);
        boolean isXAxis = ((Direction)blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_() == Direction.Axis.X;
        double v = (double)(((isXAxis ? angle : -angle) + 90.0f) / 180.0f) * Math.PI;
        double sin = Math.sin(v) * (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? 0.8125 : 1.125);
        double cos = Math.cos(v) * (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? 0.8125 : 1.125);
        double dstY = -1000.0 - sin - 1.25 - (double)pos.m_123342_();
        double dstX = (double)pos.m_123341_() - cos - 0.5 - (double)pos.m_123341_();
        double dstZ = (double)pos.m_123343_() - cos - 0.5 - (double)pos.m_123343_();
        PoseStack ms = new PoseStack();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        msr.translate((Vec3i)this.getVisualPosition());
        if (((PumpjackCrankBlockEntity)this.blockEntity).bearingPos != null) {
            PumpjackBearingBlockEntity bearing = (PumpjackBearingBlockEntity)((Object)((PumpjackCrankBlockEntity)this.blockEntity).bearing.get());
            float interpolatedAngle = 0.0f;
            if (bearing != null) {
                interpolatedAngle = bearing.getInterpolatedAngle(partialTicks);
            }
            if (((PumpjackCrankBlockEntity)this.blockEntity).inPonderAngle != -2.1474836E9f) {
                interpolatedAngle = ((PumpjackCrankBlockEntity)this.blockEntity).inPonderAngle;
            }
            if (!isXAxis) {
                interpolatedAngle *= -1.0f;
            }
            Vec2 crankBearingLocation = new Vec2((float)(((PumpjackCrankBlockEntity)this.blockEntity).crankBearingLocation.f_82479_ * Math.cos((double)(interpolatedAngle / 180.0f) * Math.PI) - ((PumpjackCrankBlockEntity)this.blockEntity).crankBearingLocation.f_82480_ * Math.sin((double)(interpolatedAngle / 180.0f) * Math.PI)) + 0.5f, (float)(((PumpjackCrankBlockEntity)this.blockEntity).crankBearingLocation.f_82479_ * Math.sin((double)(interpolatedAngle / 180.0f) * Math.PI) + ((PumpjackCrankBlockEntity)this.blockEntity).crankBearingLocation.f_82480_ * Math.cos((double)(interpolatedAngle / 180.0f) * Math.PI)) + 0.5f);
            crankBearingLocation = isXAxis ? crankBearingLocation.m_165910_(new Vec2((float)((PumpjackCrankBlockEntity)this.blockEntity).bearingPos.m_123341_(), (float)((PumpjackCrankBlockEntity)this.blockEntity).bearingPos.m_123342_())) : crankBearingLocation.m_165910_(new Vec2((float)((PumpjackCrankBlockEntity)this.blockEntity).bearingPos.m_123343_(), (float)((PumpjackCrankBlockEntity)this.blockEntity).bearingPos.m_123342_()));
            dstY = (double)crankBearingLocation.f_82471_ - sin - 1.25 - (double)pos.m_123342_();
            dstX = (double)crankBearingLocation.f_82470_ - cos - 0.5 - (double)pos.m_123341_();
            dstZ = (double)crankBearingLocation.f_82470_ - cos - 0.5 - (double)pos.m_123343_();
        }
        if (isXAxis) {
            ((PoseTransformStack)msr.translate(0.5, 1.25, 0.0)).rotateZDegrees(angle);
        } else {
            ((PoseTransformStack)((PoseTransformStack)msr.translate(0.0, 1.25, 0.5)).rotateYDegrees(90.0f)).rotateZDegrees(angle);
        }
        (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.crank : this.large_crank).setTransform(ms);
        (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.large_crank : this.crank).setZeroTransform();
        ms = new PoseStack();
        msr = TransformStack.of((PoseStack)ms);
        msr.translate((Vec3i)this.getVisualPosition());
        if (isXAxis) {
            ((PoseTransformStack)((PoseTransformStack)msr.translate(0.5, 1.25, 0.0)).translate(cos, sin, 0.0)).rotateZDegrees((float)(Math.atan2(dstY, dstX) * 180.0 / Math.PI - 90.0));
        } else {
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)msr.translate(0.0, 1.25, 0.5)).translate(0.0, sin, cos)).rotateYDegrees(90.0f)).rotateZDegrees((float)(Math.atan2(dstZ, dstY) * 180.0 / Math.PI));
        }
        (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.crank_rod : this.large_crank_rod).setTransform(ms);
        (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.large_crank_rod : this.crank_rod).setZeroTransform();
        this.crank.setChanged();
        this.crank_rod.setChanged();
        this.large_crank_rod.setChanged();
        this.large_crank.setChanged();
    }

    public void update(float partialTick) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    public void updateLight(float pt) {
        this.relight(this.pos, new FlatLit[]{this.shaft, this.crank, this.crank_rod, this.large_crank_rod, this.large_crank});
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.shaft);
        consumer.accept((Instance)this.crank);
        consumer.accept((Instance)this.crank_rod);
        consumer.accept((Instance)this.large_crank);
        consumer.accept((Instance)this.large_crank_rod);
    }

    protected void _delete() {
        this.shaft.delete();
        this.crank.delete();
        this.crank_rod.delete();
        this.large_crank_rod.delete();
        this.large_crank.delete();
    }
}

