/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.block;

import com.nick.chimes.block.ChimesBlocks;
import com.nick.chimes.block.entity.WindChimeBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindChimeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public WindChimeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, WATERLOGGED, FACING});
    }

    protected static void removeBottomHalf(Level world, BlockPos pos, BlockState state, Player player) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER && world.m_8055_(pos.m_7494_()).m_60734_() == state.m_60734_() && world.m_8055_(pos.m_7494_()).m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            if (!((Boolean)world.m_8055_(pos.m_7494_()).m_61143_((Property)WATERLOGGED)).booleanValue()) {
                world.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 35);
            } else {
                world.m_7731_(pos.m_7494_(), Blocks.f_49990_.m_49966_(), 35);
            }
        }
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            if (player.m_7500_()) {
                WindChimeBlock.removeBottomHalf(worldIn, pos, state, player);
            } else {
                WindChimeBlock.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @javax.annotation.Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, Blocks.f_50016_.m_49966_(), te, stack);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 10);
        worldIn.m_7731_(pos.m_7495_(), (BlockState)((BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.m_6425_(pos.m_7495_()).m_192917_((Fluid)Fluids.f_76193_))), 10);
    }

    public void m_7892_(BlockState p_60495_, Level p_60496_, BlockPos p_60497_, Entity p_60498_) {
        super.m_7892_(p_60495_, p_60496_, p_60497_, p_60498_);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((DoubleBlockHalf)stateIn.m_61143_(HALF)).equals((Object)DoubleBlockHalf.UPPER) ? worldIn.m_8055_(currentPos.m_7495_()).m_60734_() != this || !this.m_7898_(facingState, (LevelReader)worldIn, currentPos) : worldIn.m_8055_(currentPos.m_7494_()).m_60734_() != this) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        if (pos.m_123342_() < context.m_43725_().m_151558_() && context.m_43725_().m_8055_(pos.m_7495_()).m_60629_(context)) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_)));
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !worldIn.m_8055_(pos.m_7494_()).m_60812_((BlockGetter)worldIn, pos).m_83263_(Direction.DOWN).m_83281_() || worldIn.m_8055_(pos.m_7494_()).m_60783_((BlockGetter)worldIn, pos, Direction.DOWN);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_8133_(BlockState state, Level worldIn, BlockPos pos, int id, int param) {
        super.m_8133_(state, worldIn, pos, id, param);
        return worldIn.m_7702_(pos) == null ? false : worldIn.m_7702_(pos).m_7531_(id, param);
    }

    public RenderShape m_7514_(BlockState p_49753_) {
        return RenderShape.MODEL;
    }

    protected boolean chime(Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (!world.f_46443_ && tileentity instanceof WindChimeBE) {
            ((WindChimeBE)tileentity).chime();
            return true;
        }
        return false;
    }

    public void playChimeSound(Level world, BlockPos pos) {
        this.playChimeSound(world, pos);
    }

    public void playTieSound(Level world, BlockPos pos) {
        this.playTieSound(world, pos);
    }

    public void setChiming(BlockState state, Level level, BlockPos pos) {
        this.chime(level, pos);
        this.playChimeSound(level, pos);
        if (((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            this.chime(level, pos.m_7495_());
        } else {
            this.chime(level, pos.m_7494_());
        }
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        if (!player.m_21205_().m_150930_(Items.f_42398_)) {
            this.playChimeSound(level, pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!(player.m_21205_().m_41720_() instanceof AxeItem)) {
            this.playChimeSound(worldIn, pos);
            this.chime(worldIn, pos);
            if (worldIn.m_8055_(pos).m_61143_(HALF) == DoubleBlockHalf.UPPER && worldIn.m_8055_(pos.m_7495_()).m_60734_() == ChimesBlocks.AMETHYSTCHIMES.get()) {
                this.chime(worldIn, pos.m_7495_());
            } else if (worldIn.m_8055_(pos).m_61143_(HALF) == DoubleBlockHalf.LOWER && worldIn.m_8055_(pos.m_7494_()).m_60734_() == ChimesBlocks.AMETHYSTCHIMES.get()) {
                this.chime(worldIn, pos.m_7494_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos pos = hit.m_82425_();
        this.chime(worldIn, pos);
        this.playChimeSound(worldIn, pos);
        this.setChiming(state, worldIn, pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level p_153212_, @NotNull BlockState p_153213_, @NotNull BlockEntityType<T> p_153214_) {
        return (p_155253_, p_155254_, p_155255_, p_155256_) -> ((WindChimeBE)p_155256_).tick();
    }
}

