/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.data.recipes.vanilla;

import com.google.common.base.Supplier;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllItems;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import fr.lucreeper74.createmetallurgy.CreateMetallurgy;
import fr.lucreeper74.createmetallurgy.data.recipes.CMRecipeProvider;
import fr.lucreeper74.createmetallurgy.registries.CMBlocks;
import fr.lucreeper74.createmetallurgy.registries.CMItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;

public class CMStandardRecipeGen
extends CMRecipeProvider {
    private CMRecipeProvider.Marker MATERIALS = this.enterFolder("materials");
    CMRecipeProvider.GeneratedRecipe RAW_WOLFRAMITE = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.RAW_WOLFRAMITE).returns(9).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMBlocks.RAW_WOLFRAMITE_BLOCK.get())).viaShapeless(b -> b.m_126209_((ItemLike)CMBlocks.RAW_WOLFRAMITE_BLOCK.get()));
    CMRecipeProvider.GeneratedRecipe RAW_WOLFRAMITE_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.RAW_WOLFRAMITE_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMItems.RAW_WOLFRAMITE.get())).viaShaped(b -> b.m_126127_(Character.valueOf('C'), (ItemLike)CMItems.RAW_WOLFRAMITE.get()).m_126130_("CCC").m_126130_("CCC").m_126130_("CCC"));
    CMRecipeProvider.GeneratedRecipe TUNGSTEN_NUGGET = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.TUNGSTEN_NUGGET).returns(9).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMItems.TUNGSTEN_INGOT.get())).viaShapeless(b -> b.m_126209_((ItemLike)CMItems.TUNGSTEN_INGOT.get()));
    CMRecipeProvider.GeneratedRecipe TUNGSTEN_INGOT = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.TUNGSTEN_INGOT).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMItems.TUNGSTEN_NUGGET.get())).viaShaped(b -> b.m_126127_(Character.valueOf('C'), (ItemLike)CMItems.TUNGSTEN_NUGGET.get()).m_126130_("CCC").m_126130_("CCC").m_126130_("CCC"));
    CMRecipeProvider.GeneratedRecipe TUNGSTEN_INGOT_FROM_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.TUNGSTEN_INGOT).withSuffix("_from_block").returns(9).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMItems.TUNGSTEN_INGOT.get())).viaShapeless(b -> b.m_126209_((ItemLike)CMBlocks.TUNGSTEN_BLOCK.get()));
    CMRecipeProvider.GeneratedRecipe TUNGSTEN_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.TUNGSTEN_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMItems.TUNGSTEN_INGOT.get())).viaShaped(b -> b.m_126127_(Character.valueOf('C'), (ItemLike)CMItems.TUNGSTEN_INGOT.get()).m_126130_("CCC").m_126130_("CCC").m_126130_("CCC"));
    CMRecipeProvider.GeneratedRecipe OBDURIUM_INGOT_FROM_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.OBDURIUM_INGOT).withSuffix("_from_block").returns(9).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMItems.OBDURIUM_INGOT.get())).viaShapeless(b -> b.m_126209_((ItemLike)CMBlocks.OBDURIUM_BLOCK.get()));
    CMRecipeProvider.GeneratedRecipe OBDURIUM_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.OBDURIUM_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMItems.OBDURIUM_INGOT.get())).viaShaped(b -> b.m_126127_(Character.valueOf('C'), (ItemLike)CMItems.OBDURIUM_INGOT.get()).m_126130_("CCC").m_126130_("CCC").m_126130_("CCC"));
    CMRecipeProvider.GeneratedRecipe STEEL_INGOT_FROM_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.STEEL_INGOT).withSuffix("_from_block").returns(9).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMItems.STEEL_INGOT.get())).viaShapeless(b -> b.m_126209_((ItemLike)CMBlocks.STEEL_BLOCK.get()));
    CMRecipeProvider.GeneratedRecipe STEEL_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.STEEL_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMItems.STEEL_INGOT.get())).viaShaped(b -> b.m_126127_(Character.valueOf('C'), (ItemLike)CMItems.STEEL_INGOT.get()).m_126130_("CCC").m_126130_("CCC").m_126130_("CCC"));
    CMRecipeProvider.GeneratedRecipe COKE_FROM_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.COKE).withSuffix("_from_block").returns(9).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMItems.COKE.get())).viaShapeless(b -> b.m_126209_((ItemLike)CMBlocks.COKE_BLOCK.get()));
    CMRecipeProvider.GeneratedRecipe COKE_BLOCK = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.COKE_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> CMItems.COKE.get())).viaShaped(b -> b.m_126127_(Character.valueOf('C'), (ItemLike)CMItems.COKE.get()).m_126130_("CCC").m_126130_("CCC").m_126130_("CCC"));
    CMRecipeProvider.GeneratedRecipe GRAPHITE = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.GRAPHITE).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)CMRecipeProvider.T::coal)).viaShapeless(b -> b.m_126209_((ItemLike)Items.f_42461_).m_126211_((ItemLike)Items.f_42413_, 8));
    CMRecipeProvider.GeneratedRecipe SANDPAPER_BELT = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.SANDPAPER_BELT).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)CMRecipeProvider.T::sandpaper)).viaShaped(b -> b.m_206416_(Character.valueOf('D'), Tags.Items.SAND_COLORLESS).m_126130_("DDD").m_126130_("DDD"));
    CMRecipeProvider.GeneratedRecipe TUNGSTEN_WIRE = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.TUNGSTEN_WIRE).returns(2).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)CMRecipeProvider.T::tungstenIngot)).viaShapeless(b -> b.m_206419_(CMRecipeProvider.T.tungstenIngot()).m_126209_((ItemLike)Items.f_42574_));
    CMRecipeProvider.GeneratedRecipe TUNGSTEN_WIRE_SPOOL = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.TUNGSTEN_WIRE_SPOOL).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)CMRecipeProvider.T::tungstenWire)).viaShaped(b -> b.m_206416_(Character.valueOf('W'), CMRecipeProvider.T.tungstenWire()).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126130_(" W ").m_126130_("WSW").m_126130_(" W "));
    CMRecipeProvider.GeneratedRecipe STURDY_WHISK = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.STURDY_WHISK).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)CMRecipeProvider.T::tungstenSheet)).viaShaped(b -> b.m_206416_(Character.valueOf('T'), CMRecipeProvider.T.tungstenSheet()).m_126127_(Character.valueOf('A'), CMRecipeProvider.T.andesiteAlloy()).m_126127_(Character.valueOf('B'), (ItemLike)AllItems.STURDY_SHEET.get()).m_126130_(" A ").m_126130_("BAB").m_126130_("TBT"));
    CMRecipeProvider.GeneratedRecipe COKE = this.create((Supplier<ItemLike>)((Supplier)() -> CMItems.COKE.get())).withSuffix("_from_coal").viaCookingTag((Supplier<TagKey<Item>>)((Supplier)CMRecipeProvider.T::coal)).rewardXP(0.5f).forDuration(200).inBlastFurnace();
    private CMRecipeProvider.Marker CONTENT = this.enterFolder("content");
    CMRecipeProvider.GeneratedRecipe BELT_GRINDER = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.BELT_GRINDER_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CMRecipeProvider.T::sandpaperBelt)).viaShaped(b -> b.m_126127_(Character.valueOf('B'), CMRecipeProvider.T.sandpaperBelt()).m_126127_(Character.valueOf('C'), CMRecipeProvider.T.andesiteCasing()).m_126127_(Character.valueOf('I'), CMRecipeProvider.T.shaft()).m_126130_("B").m_126130_("C").m_126130_("I"));
    CMRecipeProvider.GeneratedRecipe CASTING_TABLE = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.CASTING_TABLE_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CMRecipeProvider.T::andesiteAlloy)).viaShaped(b -> b.m_126127_(Character.valueOf('A'), CMRecipeProvider.T.andesiteAlloy()).m_126130_("AAA").m_126130_("A A").m_126130_("A A"));
    CMRecipeProvider.GeneratedRecipe CASTING_BASIN = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.CASTING_BASIN_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CMRecipeProvider.T::andesiteAlloy)).viaShaped(b -> b.m_126127_(Character.valueOf('A'), CMRecipeProvider.T.andesiteAlloy()).m_126130_("A A").m_126130_("A A").m_126130_(" A "));
    CMRecipeProvider.GeneratedRecipe FOUNDRY_LID = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.FOUNDRY_LID_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CMRecipeProvider.T::andesiteAlloy)).viaShaped(b -> b.m_126127_(Character.valueOf('A'), CMRecipeProvider.T.andesiteAlloy()).m_126130_("AAA").m_126130_("A A"));
    CMRecipeProvider.GeneratedRecipe FOUNDRY_BASIN = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.FOUNDRY_BASIN_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CMRecipeProvider.T::refractoryMortar)).viaShaped(b -> b.m_126127_(Character.valueOf('A'), CMRecipeProvider.T.andesiteAlloy()).m_126127_(Character.valueOf('P'), CMRecipeProvider.T.refractoryMortar()).m_126130_("A A").m_126130_("APA").m_126130_("AAA"));
    CMRecipeProvider.GeneratedRecipe FOUNDRY_MIXER = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.FOUNDRY_MIXER_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CMRecipeProvider.T::refractoryMortar)).viaShaped(b -> b.m_126127_(Character.valueOf('A'), CMRecipeProvider.T.cog()).m_126127_(Character.valueOf('B'), CMRecipeProvider.T.copperCasing()).m_126127_(Character.valueOf('C'), (ItemLike)CMItems.STURDY_WHISK.get()).m_126130_("A").m_126130_("B").m_126130_("C"));
    CMRecipeProvider.GeneratedRecipe FOUNDRY_UNIT = this.create((ItemProviderEntry<? extends ItemLike>)CMItems.FOUNDRY_UNIT).unlockedByTag((Supplier<TagKey<Item>>)((Supplier)CMRecipeProvider.T::steelIngot)).viaShaped(b -> b.m_206416_(Character.valueOf('S'), CMRecipeProvider.T.steelIngot()).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42522_).m_126130_("SCS"));
    CMRecipeProvider.GeneratedRecipe FAUCET = this.create((ItemProviderEntry<? extends ItemLike>)CMBlocks.FAUCET_BLOCK).unlockedBy((Supplier<? extends ItemLike>)((Supplier)CMRecipeProvider.T::andesiteAlloy)).viaShaped(b -> b.m_126127_(Character.valueOf('A'), CMRecipeProvider.T.andesiteAlloy()).m_126130_("A A").m_126130_(" A "));
    String currentFolder = "";

    CMRecipeProvider.Marker enterFolder(String folder) {
        this.currentFolder = folder;
        return new CMRecipeProvider.Marker();
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike> result) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get()));
    }

    CMRecipeProvider.GeneratedRecipe createSpecial(Supplier<? extends SimpleCraftingRecipeSerializer<?>> serializer, String recipeType, String path) {
        ResourceLocation location = CreateMetallurgy.genRL(recipeType + "/" + this.currentFolder + "/" + path);
        return this.register(consumer -> {
            SpecialRecipeBuilder b = SpecialRecipeBuilder.m_245676_((RecipeSerializer)((RecipeSerializer)serializer.get()));
            b.m_126359_(consumer, location.toString());
        });
    }

    public String m_6055_() {
        return "Create: Metallurgy's Standard Recipes";
    }

    public CMStandardRecipeGen(PackOutput packOutput) {
        super(packOutput);
    }

    class GeneratedRecipeBuilder {
        private String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        List<ICondition> recipeConditions;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.recipeConditions = new ArrayList<ICondition>();
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)item.get()}).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_204145_((TagKey)tag.get()).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition((ICondition)new ModLoadedCondition(modid));
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
        }

        GeneratedRecipeBuilder withCondition(ICondition condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        CMRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return CMStandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)CMStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        CMRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return CMStandardRecipeGen.this.register(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)CMStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        CMRecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends Item> base, Supplier<Ingredient> upgradeMaterial) {
            return CMStandardRecipeGen.this.register(consumer -> {
                SmithingTransformRecipeBuilder b = SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)base.get()}), (Ingredient)((Ingredient)upgradeMaterial.get()), (RecipeCategory)RecipeCategory.COMBAT, (Item)((ItemLike)this.result.get()).m_5456_());
                b.m_266439_("has_item", (CriterionTriggerInstance)CMStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)base.get()}).m_45077_()}));
                b.m_266371_(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return CreateMetallurgy.genRL(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            return CreateMetallurgy.genRL(recipeType + "/" + this.path + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? CatnipServices.REGISTRIES.getKeyOrThrow(((ItemLike)this.result.get()).m_5456_()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get()))));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;
            private final RecipeSerializer<? extends AbstractCookingRecipe> FURNACE = RecipeSerializer.f_44091_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> SMOKER = RecipeSerializer.f_44093_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> BLAST = RecipeSerializer.f_44092_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> CAMPFIRE = RecipeSerializer.f_44094_;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            CMRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            CMRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(this.FURNACE, builder, 1.0f);
            }

            CMRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            CMRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                this.create(this.CAMPFIRE, builder, 3.0f);
                return this.create(this.SMOKER, builder, 0.5f);
            }

            CMRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            CMRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                return this.create(this.BLAST, builder, 0.5f);
            }

            private CMRecipeProvider.GeneratedRecipe create(RecipeSerializer<? extends AbstractCookingRecipe> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, float cookingTimeModifier) {
                return CMStandardRecipeGen.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.m_247607_((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.f_42329_ : (ItemLike)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.m_126132_("has_item", (CriterionTriggerInstance)CMStandardRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.m_126140_(result -> consumer.accept(isOtherMod ? new ModdedCookingRecipeResult((FinishedRecipe)result, GeneratedRecipeBuilder.this.compatDatagenOutput, GeneratedRecipeBuilder.this.recipeConditions) : result), GeneratedRecipeBuilder.this.createSimpleLocation(CatnipServices.REGISTRIES.getKeyOrThrow(serializer).m_135815_()));
                });
            }
        }
    }

    private static class ModdedCookingRecipeResult
    implements FinishedRecipe {
        private FinishedRecipe wrapped;
        private ResourceLocation outputOverride;
        private List<ICondition> conditions;

        public ModdedCookingRecipeResult(FinishedRecipe wrapped, ResourceLocation outputOverride, List<ICondition> conditions) {
            this.wrapped = wrapped;
            this.outputOverride = outputOverride;
            this.conditions = conditions;
        }

        public ResourceLocation m_6445_() {
            return this.wrapped.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.wrapped.m_6637_();
        }

        public JsonObject m_5860_() {
            return this.wrapped.m_5860_();
        }

        public ResourceLocation m_6448_() {
            return this.wrapped.m_6448_();
        }

        public void m_7917_(JsonObject object) {
            this.wrapped.m_7917_(object);
            object.addProperty("result", this.outputOverride.toString());
            JsonArray conds = new JsonArray();
            this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            object.add("conditions", (JsonElement)conds);
        }
    }
}

