/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes.FoundryRecipe;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class FoundryRecipeBuilder<T extends FoundryRecipe>
extends ProcessingRecipeBuilder<T> {
    protected int minHeatRequirement = -50;
    protected int maxHeatRequirement = 50;

    public FoundryRecipeBuilder(ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory, ResourceLocation recipeId) {
        super(factory, recipeId);
    }

    public FoundryRecipeBuilder<T> requiresMinHeat(int minHeat) {
        this.minHeatRequirement = minHeat;
        return this;
    }

    public FoundryRecipeBuilder<T> requiresMaxHeat(int maxHeat) {
        this.maxHeatRequirement = maxHeat;
        return this;
    }

    public T build() {
        FoundryRecipe recipe = (FoundryRecipe)this.factory.create(this.params);
        recipe.minHeat = this.minHeatRequirement;
        recipe.maxHeat = this.maxHeatRequirement;
        return (T)((Object)recipe);
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new DataGenResult<ProcessingRecipe>(this.build(), this.recipeConditions));
    }

    public static class DataGenResult<S extends FoundryRecipe>
    implements FinishedRecipe {
        private List<ICondition> recipeConditions;
        private ProcessingRecipeSerializer<S> serializer;
        private ResourceLocation id;
        private S recipe;

        public DataGenResult(S recipe, List<ICondition> recipeConditions) {
            this.recipe = recipe;
            this.recipeConditions = recipeConditions;
            IRecipeTypeInfo recipeType = this.recipe.getTypeInfo();
            ResourceLocation typeId = recipeType.getId();
            if (!(recipeType.getSerializer() instanceof ProcessingRecipeSerializer)) {
                throw new IllegalStateException("Cannot datagen FoundryRecipe of type: " + String.valueOf(typeId));
            }
            this.id = new ResourceLocation(recipe.m_6423_().m_135827_(), typeId.m_135815_() + "/" + recipe.m_6423_().m_135815_());
            this.serializer = (ProcessingRecipeSerializer)recipe.m_7707_();
        }

        public void m_7917_(JsonObject json) {
            this.serializer.write(json, this.recipe);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conds = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            json.add("conditions", (JsonElement)conds);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

