/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.FoundryData;
import fr.lucreeper74.createmetallurgy.utils.CMLang;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;

public class FoundryDisplaySource
extends DisplaySource {
    public static final List<MutableComponent> notEnoughSpaceSingle = List.of(CMLang.translateDirect("display_source.foundry.not_enough_space", new Object[0]), CMLang.translateDirect("display_source.foundry.for_foundry_status", new Object[0]));

    public List<MutableComponent> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        if (stats.maxRows() < 2) {
            return notEnoughSpaceSingle;
        }
        boolean isBook = context.getTargetBlockEntity() instanceof LecternBlockEntity;
        if (isBook) {
            Stream<MutableComponent> componentList = this.getComponents(context).map(components -> {
                Optional reduce = components.stream().reduce(MutableComponent::m_7220_);
                return reduce.orElse(EMPTY_LINE);
            });
            return List.of(componentList.reduce((comp1, comp2) -> comp1.m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)comp2)).orElse(EMPTY_LINE));
        }
        return this.getComponents(context).map(components -> {
            Optional reduce = components.stream().reduce(MutableComponent::m_7220_);
            return reduce.orElse(EMPTY_LINE);
        }).toList();
    }

    private Stream<List<MutableComponent>> getComponents(DisplayLinkContext context) {
        BlockEntity sourceBE = context.getSourceBlockEntity();
        if (!(sourceBE instanceof CrucibleBlockEntity)) {
            return Stream.of(EMPTY);
        }
        CrucibleBlockEntity crucibleBE = (CrucibleBlockEntity)sourceBE;
        crucibleBE = crucibleBE.getControllerBE();
        if (crucibleBE == null) {
            return Stream.of(EMPTY);
        }
        FoundryData foundry = crucibleBE.foundry;
        foundry.updateTemperature(crucibleBE);
        return Stream.of(List.of(CMLang.translateDirect("foundry.status", new Object[0]).m_130946_(":")), List.of(foundry.getHeatLevelComponent(crucibleBE.getBaseSize())));
    }

    protected String getTranslationKey() {
        return "foundry_status";
    }
}

