/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible;

import com.simibubi.create.AllKeys;
import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.MeltingInventory;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.MeltingSlot;
import fr.lucreeper74.createmetallurgy.utils.CMLang;
import java.util.List;
import joptsimple.internal.Strings;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class FoundryData {
    protected MeltingInventory inputInv;
    private boolean active;
    private int currentHeat;
    public LerpedFloat gauge = LerpedFloat.linear();

    protected void createInventory(CrucibleBlockEntity be, int size) {
        this.inputInv = new MeltingInventory(be, size);
    }

    public void tick(CrucibleBlockEntity be) {
        if (!this.active) {
            return;
        }
        if (be.m_58904_().f_46443_) {
            this.gauge.tickChaser();
            this.gauge.chase((double)((float)this.getCurrentHeat() / (float)this.getMaxHeat(be)), (double)0.05f, LerpedFloat.Chaser.EXP);
            return;
        }
        if (this.updateTemperature(be)) {
            be.notifyUpdate();
        }
        for (int slot = 0; slot < be.getTotalSize(); ++slot) {
            MeltingSlot meltingSlot = this.inputInv.getSlot(slot);
            if (meltingSlot.getStack().m_41619_()) continue;
            if (meltingSlot.canMelt()) {
                meltingSlot.heatItem();
                continue;
            }
            meltingSlot.coolItem();
        }
        be.tankInventory.process();
    }

    public boolean updateTemperature(CrucibleBlockEntity be) {
        BlockPos controllerPos = be.m_58899_();
        Level level = be.m_58904_();
        int prevActive = this.currentHeat;
        this.currentHeat = 0;
        for (int xOffset = 0; xOffset < be.getWidth(); ++xOffset) {
            for (int zOffset = 0; zOffset < be.getWidth(); ++zOffset) {
                BlockPos pos = controllerPos.m_7918_(xOffset, -1, zOffset);
                BlockState blockState = level.m_8055_(pos);
                float heat = BoilerHeater.findHeat((Level)level, (BlockPos)pos, (BlockState)blockState);
                this.currentHeat = (int)((float)this.currentHeat + heat);
            }
        }
        return prevActive != this.currentHeat;
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("Controlled", this.active);
        nbt.m_128405_("currentHeat", this.currentHeat);
        return nbt;
    }

    public void read(CompoundTag nbt) {
        this.active = nbt.m_128471_("Controlled");
        this.currentHeat = nbt.m_128451_("currentHeat");
    }

    public boolean isActive() {
        return this.active;
    }

    public int getCurrentHeat() {
        return this.currentHeat;
    }

    public int getMaxHeat(CrucibleBlockEntity be) {
        return be.getWidth() * be.getWidth() * 2;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public MeltingInventory getInventory() {
        return this.inputInv;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, int foundrySize) {
        if (!this.isActive()) {
            return false;
        }
        CMLang.translate("foundry.status", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CMLang.builder().add(this.getHeatLevelComponent(foundrySize)).forGoggles(tooltip);
        tooltip.add((Component)Component.m_237119_());
        if (AllKeys.shiftDown()) {
            int displayed = 0;
            for (int i = 0; i < this.inputInv.getSlots(); ++i) {
                MeltingSlot slot = this.inputInv.getSlot(i);
                ItemStack stackInSlot = slot.getStack();
                if (stackInSlot.m_41619_()) continue;
                if (displayed > 4) {
                    CMLang.text("...").style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
                    break;
                }
                int duration = slot.processDuration;
                CMLang.text("").add(CreateLang.itemName((ItemStack)stackInSlot).style(ChatFormatting.GRAY)).space().add(duration > 0 ? this.progressBarComponent(duration, slot.processingTime, 9) : CMLang.text("X").style(ChatFormatting.RED).style(ChatFormatting.BOLD).component()).forGoggles(tooltip, 1);
                ++displayed;
            }
            if (displayed > 0) {
                tooltip.add((Component)Component.m_237119_());
            }
        }
        return true;
    }

    @NotNull
    public MutableComponent getHeatLevelComponent(int foundrySize) {
        FoundryHeatLevel heatLevel = FoundryHeatLevel.getHeatLevel(this.getCurrentHeat(), foundrySize);
        LangBuilder builder = CMLang.text(TooltipHelper.makeProgressBar((int)3, (int)heatLevel.ordinal()));
        builder.translate("foundry." + CMLang.asId(heatLevel.name()), new Object[0]).space().text("(").add(CMLang.number(this.currentHeat)).space().translate("generic.unit.thermal", new Object[0]).text(")").space();
        builder.color(heatLevel.getTextColor());
        return builder.component();
    }

    private MutableComponent progressBarComponent(int maxValue, int progress, int maxLength) {
        int level = maxLength - progress * maxLength / maxValue;
        return Component.m_237119_().m_7220_((Component)this.bars(Math.min(level, 3), ChatFormatting.DARK_RED)).m_7220_((Component)this.bars(level > 3 ? Math.min(level - 3, 3) : 0, ChatFormatting.GOLD)).m_7220_((Component)this.bars(level > 6 ? Math.min(level - 6, 3) : 0, ChatFormatting.YELLOW)).m_7220_((Component)this.bars(Math.max(0, maxLength - level), ChatFormatting.DARK_GRAY));
    }

    private MutableComponent bars(int count, ChatFormatting format) {
        return Component.m_237113_((String)Strings.repeat((char)'|', (int)count)).m_130940_(format);
    }

    public static enum FoundryHeatLevel {
        COOLING(ChatFormatting.GREEN.m_126665_()),
        STABLE(ChatFormatting.RED.m_126665_()),
        HEATING(15237888),
        OVERHEATING(6067176);

        private final int textColor;

        private FoundryHeatLevel(int textColor) {
            this.textColor = textColor;
        }

        public int getTextColor() {
            return this.textColor;
        }

        public static FoundryHeatLevel getHeatLevel(int heat, int foundrySize) {
            if (heat >= foundrySize * 2) {
                return OVERHEATING;
            }
            if (heat > 0) {
                return HEATING;
            }
            if (heat < 0) {
                return COOLING;
            }
            return STABLE;
        }
    }
}

