/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.casting;

import fr.lucreeper74.createmetallurgy.content.blocks.casting.CastingBlockEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class CastingFluidTank
extends FluidTank {
    private final CastingBlockEntity be;
    protected LerpedFloat fluidLevel;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;

    public CastingFluidTank(CastingBlockEntity be) {
        super(0);
        this.be = be;
        this.fluidLevel = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
    }

    public FluidTank readFromNBT(CompoundTag nbt, boolean clientPacket) {
        this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid")));
        this.setCapacity(nbt.m_128451_("capacity"));
        this.fluidLevel.readNBT(nbt.m_128469_("level"), clientPacket);
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128365_("fluid", (Tag)this.fluid.writeToNBT(new CompoundTag()));
        nbt.m_128405_("capacity", this.capacity);
        nbt.m_128365_("level", (Tag)this.fluidLevel.writeNBT());
        return nbt;
    }

    public void tick() {
        LerpedFloat fluidLevel;
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.updateFluids();
            }
        }
        if ((fluidLevel = this.getFluidLevel()) != null) {
            fluidLevel.tickChaser();
        }
    }

    public void sendDataLazily() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        this.updateFluids();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    protected void updateFluids() {
        this.be.sendData();
        this.be.m_6596_();
    }

    public void reset() {
        this.capacity = 0;
        this.fluid = FluidStack.EMPTY;
    }

    protected void onContentsChanged() {
        if (!this.be.m_58898_()) {
            return;
        }
        this.fluidLevel.chase((double)((float)this.getFluidAmount() / (float)this.getCapacity()), 0.25, LerpedFloat.Chaser.EXP);
        if (!this.be.m_58904_().m_5776_()) {
            this.sendDataLazily();
        }
        super.onContentsChanged();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        int capacity = this.capacity;
        if (capacity == 0) {
            capacity = this.be.initProcess(resource, action);
            if (capacity <= 0) {
                return 0;
            }
            if (action.execute()) {
                this.capacity = capacity;
            }
        }
        if (this.fluid.isEmpty()) {
            int amount = Math.min(capacity, resource.getAmount());
            if (action.execute()) {
                this.fluid = new FluidStack(resource, amount);
                this.onContentsChanged();
            }
            return amount;
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int space = capacity - this.fluid.getAmount();
        if (space <= 0) {
            return 0;
        }
        int amount = resource.getAmount();
        if (amount < space) {
            if (action.execute()) {
                this.fluid.grow(amount);
                this.onContentsChanged();
            }
            return amount;
        }
        if (action.execute()) {
            this.fluid.setAmount(capacity);
            this.onContentsChanged();
        }
        return space;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = Math.min(this.fluid.getAmount(), maxDrain);
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action.execute() && drained > 0) {
            this.fluid.shrink(drained);
            if (this.fluid.isEmpty()) {
                this.be.reset();
            } else {
                this.onContentsChanged();
            }
        }
        return stack;
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }
}

