/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.belt_grinder;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import fr.lucreeper74.createmetallurgy.content.blocks.belt_grinder.BeltGrinderBlock;
import fr.lucreeper74.createmetallurgy.content.blocks.belt_grinder.BeltGrinderFilterSlot;
import fr.lucreeper74.createmetallurgy.content.blocks.belt_grinder.GrindingRecipe;
import fr.lucreeper74.createmetallurgy.registries.CMRecipeTypes;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BeltGrinderBlockEntity
extends KineticBlockEntity {
    private static final Object grindingRecipesKey = new Object();
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    public ProcessingInventory inv = new ProcessingInventory(this::start);
    public int processingTick;
    private int recipeIndex = 0;
    private FilteringBehaviour filtering;

    public BeltGrinderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemCapability = LazyOptional.of(() -> this.inv);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new BeltGrinderFilterSlot()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("inv", (Tag)this.inv.serializeNBT());
        compound.m_128405_("processTicks", this.processingTick);
        compound.m_128405_("RecipeIndex", this.recipeIndex);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.inv.deserializeNBT(compound.m_128469_("inv"));
        this.processingTick = compound.m_128451_("processTicks");
        this.recipeIndex = compound.m_128451_("RecipeIndex");
        super.read(compound, clientPacket);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inv);
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inv.remainingTime == -1.0f) {
            if (!this.inv.isEmpty() && !this.inv.appliedRecipe) {
                this.start(this.inv.getStackInSlot(0));
            }
            return;
        }
        float processingSpeed = Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inv.remainingTime -= processingSpeed;
        if (this.inv.remainingTime > 0.0f) {
            this.spawnParticles(this.inv.getStackInSlot(0));
        }
        if (this.inv.remainingTime < 5.0f && !this.inv.appliedRecipe) {
            if (this.f_58857_.f_46443_ && !this.isVirtual()) {
                return;
            }
            this.applyRecipe();
            this.inv.appliedRecipe = true;
            this.inv.recipeDuration = 20.0f;
            this.inv.remainingTime = 20.0f;
            this.sendData();
        }
        Vec3 itemMovement = this.getItemMovementVec();
        Direction itemMovementFacing = Direction.m_122366_((double)itemMovement.f_82479_, (double)itemMovement.f_82480_, (double)itemMovement.f_82481_);
        if (this.inv.remainingTime > 0.0f) {
            return;
        }
        this.inv.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inv.getSlots(); ++slot) {
            ItemStack tryExportingToBeltFunnel;
            ItemStack stack = this.inv.getStackInSlot(slot);
            if (stack.m_41619_() || (tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(stack, itemMovementFacing.m_122424_(), false)) == null) continue;
            if (tryExportingToBeltFunnel.m_41613_() != stack.m_41613_()) {
                this.inv.setStackInSlot(slot, tryExportingToBeltFunnel);
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.m_41619_()) continue;
            return;
        }
        BlockPos nextPos = this.f_58858_.m_121955_((Vec3i)BlockPos.m_274446_((Position)itemMovement));
        DirectBeltInputBehaviour behaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)nextPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.f_58857_.f_46443_ && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.inv.getSlots(); ++slot) {
                ItemStack remainder;
                ItemStack stack = this.inv.getStackInSlot(slot);
                if (stack.m_41619_() || (remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)).equals(stack, false)) continue;
                this.inv.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.m_6596_();
                this.sendData();
            }
            return;
        }
        Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(itemMovement.m_82490_(0.5).m_82520_(0.0, 0.5, 0.0));
        Vec3 outMotion = itemMovement.m_82490_(0.0625).m_82520_(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inv.getSlots(); ++slot) {
            ItemStack stack = this.inv.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            ItemEntity entityIn = new ItemEntity(this.f_58857_, outPos.f_82479_, outPos.f_82480_, outPos.f_82481_, stack);
            entityIn.m_20256_(outMotion);
            this.f_58857_.m_7967_((Entity)entityIn);
        }
        this.inv.clear();
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        this.inv.remainingTime = -1.0f;
        this.sendData();
    }

    public Vec3 getItemMovementVec() {
        boolean alongX = ((Direction)this.m_58900_().m_61143_(BeltGrinderBlock.HORIZONTAL_FACING)).m_122434_() != Direction.Axis.X;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new Vec3((double)(offset * (alongX ? 1 : 0)), 0.0, (double)(offset * (alongX ? 0 : -1)));
    }

    private void start(ItemStack inserted) {
        Recipe<?> recipe;
        if (this.inv.isEmpty()) {
            return;
        }
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        List<Recipe<?>> recipes = this.getRecipes();
        boolean valid = !recipes.isEmpty();
        int time = 50;
        if (recipes.isEmpty()) {
            this.inv.recipeDuration = 10.0f;
            this.inv.remainingTime = 10.0f;
            this.inv.appliedRecipe = false;
            this.sendData();
            return;
        }
        if (valid) {
            ++this.recipeIndex;
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
        }
        if ((recipe = recipes.get(this.recipeIndex)) instanceof CuttingRecipe) {
            time = ((CuttingRecipe)recipe).getProcessingDuration();
        }
        this.inv.recipeDuration = this.inv.remainingTime = (float)(time * Math.max(1, inserted.m_41613_() / 5));
        this.inv.appliedRecipe = false;
        this.sendData();
    }

    private List<? extends Recipe<?>> getRecipes() {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)this.inv.getStackInSlot(0), CMRecipeTypes.GRINDING.getType(), GrindingRecipe.class);
        if (assemblyRecipe.isPresent() && this.filtering.test(((GrindingRecipe)((Object)assemblyRecipe.get())).m_8043_(this.f_58857_.m_9598_()))) {
            return ImmutableList.of((Object)((Object)((GrindingRecipe)((Object)assemblyRecipe.get()))));
        }
        Predicate types = RecipeConditions.isOfType((RecipeType[])new RecipeType[]{CMRecipeTypes.GRINDING.getType(), AllRecipeTypes.SANDPAPER_POLISHING.getType()});
        List startedSearch = RecipeFinder.get((Object)grindingRecipesKey, (Level)this.f_58857_, (Predicate)types);
        return startedSearch.stream().filter(RecipeConditions.outputMatchesFilter((FilteringBehaviour)this.filtering)).filter(RecipeConditions.firstIngredientMatches((ItemStack)this.inv.getStackInSlot(0))).collect(Collectors.toList());
    }

    private void applyRecipe() {
        List<Recipe<?>> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipeIndex >= recipes.size()) {
            this.recipeIndex = 0;
        }
        Recipe<?> recipe = recipes.get(this.recipeIndex);
        int rolls = this.inv.getStackInSlot(0).m_41613_();
        this.inv.clear();
        ArrayList list = new ArrayList();
        for (int roll = 0; roll < rolls; ++roll) {
            List<ItemStack> results = new LinkedList();
            if (recipe instanceof GrindingRecipe) {
                results = ((GrindingRecipe)recipe).rollResults();
            } else if (recipe instanceof SandPaperPolishingRecipe) {
                results.add(recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_());
            }
            for (ItemStack stack : results) {
                ItemHelper.addToList((ItemStack)stack, list);
            }
        }
        for (int slot = 0; slot < list.size() && slot + 1 < this.inv.getSlots(); ++slot) {
            this.inv.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
        }
    }

    public void insertItem(ItemEntity entity) {
        if (!this.inv.isEmpty()) {
            return;
        }
        if (!entity.m_6084_()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.inv.clear();
        ItemStack remainder = this.inv.insertItem(0, entity.m_32055_().m_41777_(), false);
        if (remainder.m_41619_()) {
            entity.m_146870_();
        } else {
            entity.m_32045_(remainder);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        float speed = Math.abs(this.getSpeed());
        if (speed == 0.0f) {
            return;
        }
        if (!this.inv.isEmpty() && AnimationTickHolder.getTicks() % 4 == 0) {
            float pitch = Mth.m_14036_((float)(speed / 256.0f * 2.0f), (float)0.5f, (float)1.6f);
            AllSoundEvents.SANDING_SHORT.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.3f, this.f_58857_.f_46441_.m_188501_() * 0.5f + pitch, true);
        }
    }

    protected void spawnParticles(ItemStack stack) {
        ItemParticleOption particleData;
        if (stack == null || stack.m_41619_()) {
            return;
        }
        float speed = 1.0f;
        if (stack.m_41720_() instanceof BlockItem) {
            particleData = new BlockParticleOption(ParticleTypes.f_123794_, ((BlockItem)stack.m_41720_()).m_40614_().m_49966_());
        } else {
            particleData = new ItemParticleOption(ParticleTypes.f_123752_, stack);
            speed = 0.125f;
        }
        RandomSource r = this.f_58857_.f_46441_;
        Vec3 vec = this.getItemMovementVec();
        Vec3 pos = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        float offset = this.inv.recipeDuration != 0.0f ? this.inv.remainingTime / this.inv.recipeDuration : 0.0f;
        offset /= 2.0f;
        if (this.inv.appliedRecipe) {
            offset -= 0.5f;
        }
        this.f_58857_.m_7106_((ParticleOptions)particleData, pos.m_7096_() + -vec.f_82479_ * (double)offset, pos.m_7098_() + (double)0.45f, pos.m_7094_() + -vec.f_82481_ * (double)offset, -vec.f_82479_ * (double)speed, (double)(r.m_188501_() * speed), -vec.f_82481_ * (double)speed);
    }
}

