/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.compat.jei.category;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.FoundryData;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes.FoundryRecipe;
import fr.lucreeper74.createmetallurgy.utils.CMLang;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

public abstract class FoundryAbstractCategory<T extends FoundryRecipe>
extends CreateRecipeCategory<T> {
    private final AnimatedBlazeBurner burner = new AnimatedBlazeBurner();

    public FoundryAbstractCategory(CreateRecipeCategory.Info<T> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        List condensedIngredients = ItemHelper.condenseIngredients((NonNullList)recipe.m_7527_());
        int size = condensedIngredients.size() + recipe.getFluidIngredients().size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        int i = 0;
        for (Pair pair : condensedIngredients) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)pair.getFirst()).m_43908_()) {
                ItemStack copy = itemStack.m_41777_();
                copy.m_41764_(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 8 + xOffset + i % 3 * 19, 56 - i / 3 * 19).setBackground(FoundryAbstractCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
            ++i;
        }
        for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            int x = 8 + xOffset + i % 3 * 19;
            int y = 56 - i / 3 * 19;
            FoundryAbstractCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)x, (int)y, (FluidIngredient)fluidIngredient);
        }
        size = recipe.getRollableResults().size() + recipe.getFluidResults().size();
        i = 0;
        for (ProcessingOutput result : recipe.getRollableResults()) {
            int xPosition = 150 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 56;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xPosition, yPosition).setBackground(FoundryAbstractCategory.getRenderedSlot((ProcessingOutput)result), -1, -1).addItemStack(result.getStack())).addRichTooltipCallback(FoundryAbstractCategory.addStochasticTooltip((ProcessingOutput)result));
            ++i;
        }
        for (FluidStack fluidResult : recipe.getFluidResults()) {
            int x = 150 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int y = -19 * (i / 2) + 56;
            FoundryAbstractCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)x, (int)y, (FluidStack)fluidResult);
            ++i;
        }
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        int minHeat = ((FoundryRecipe)((Object)recipe)).getMinHeat();
        boolean noHeating = minHeat < 0;
        int minFoundryWidth = Mth.m_14167_((float)Mth.m_14116_((float)Mth.m_14045_((int)(minHeat / 2), (int)1, (int)25)));
        FoundryData.FoundryHeatLevel minHeatLevel = FoundryData.FoundryHeatLevel.getHeatLevel(minHeat, minFoundryWidth * minFoundryWidth);
        int vRows = (1 + recipe.getFluidResults().size() + recipe.getRollableResults().size()) / 2;
        if (vRows <= 2) {
            AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 144, -19 * (vRows - 1) + 32);
        }
        AllGuiTextures shadow = noHeating ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.render(graphics, 81, 58 + (noHeating ? 10 : 30));
        AllGuiTextures heatBar = noHeating ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
        heatBar.render(graphics, 4, 80);
        Font font = Minecraft.m_91087_().f_91062_;
        graphics.m_280614_(font, (Component)CMLang.translateDirect("foundry." + CMLang.asId(minHeatLevel.name()), new Object[0]), 9, 86, minHeatLevel.getTextColor(), false);
        MutableComponent minSizeText = CMLang.translateDirect("recipe.foundry.min_size", minFoundryWidth, minFoundryWidth);
        graphics.m_280614_(font, (Component)minSizeText, 145, 86, 0xFFFFFF, true);
        this.drawProcessTime(recipe, graphics, 30);
        if (minHeat >= 0) {
            this.burner.withHeat(this.getBurnerLevel(minHeatLevel).visualizeAsBlazeBurner()).draw(graphics, this.getBackground().getWidth() / 2 + 3, 55);
        }
    }

    public HeatCondition getBurnerLevel(FoundryData.FoundryHeatLevel foundryLevel) {
        return switch (foundryLevel) {
            default -> throw new IncompatibleClassChangeError();
            case FoundryData.FoundryHeatLevel.COOLING, FoundryData.FoundryHeatLevel.STABLE -> HeatCondition.NONE;
            case FoundryData.FoundryHeatLevel.HEATING -> HeatCondition.HEATED;
            case FoundryData.FoundryHeatLevel.OVERHEATING -> HeatCondition.SUPERHEATED;
        };
    }

    protected void drawProcessTime(T recipe, GuiGraphics graphics, int y) {
        int duration = recipe.getProcessingDuration();
        if (duration > 0) {
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{Float.valueOf((float)duration / 20.0f)}).m_130940_(ChatFormatting.GRAY);
            Font font = Minecraft.m_91087_().f_91062_;
            int stringWidth = font.m_92852_((FormattedText)timeString) + 5;
            graphics.m_280614_(font, (Component)timeString, 55 - stringWidth, y, 0xFFFFFF, false);
        }
    }

    @NotNull
    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        int minXSize = 142;
        int maxXSize = minXSize + 24;
        int minYSize = 82;
        int maxYSize = minYSize + 18;
        if (mouseX >= (double)minXSize && mouseX < (double)maxXSize && mouseY >= (double)minYSize && mouseY < (double)maxYSize) {
            tooltip.add((Component)CMLang.translateDirect("recipe.foundry.min_size.text", new Object[0]).m_130940_(ChatFormatting.RED));
        }
        int minXBurner = 5;
        int maxXBurner = minXBurner + 120;
        int minYBurner = 82;
        int maxYBurner = minYBurner + 18;
        if (mouseX >= (double)minXBurner && mouseX < (double)maxXBurner && mouseY >= (double)minYBurner && mouseY < (double)maxYBurner) {
            tooltip.add((Component)CMLang.translateDirect("recipe.foundry.heat_requirement.text", new Object[0]));
            tooltip.add((Component)CMLang.translate("generic.icon.down", new Object[0]).space().add(CMLang.number(((FoundryRecipe)((Object)recipe)).getMaxHeat())).space().translate("generic.unit.thermal", new Object[0]).style(ChatFormatting.RED).component());
            tooltip.add((Component)CMLang.translate("generic.icon.up", new Object[0]).space().add(CMLang.number(((FoundryRecipe)((Object)recipe)).getMinHeat())).space().translate("generic.unit.thermal", new Object[0]).style(ChatFormatting.GREEN).component());
        }
        return tooltip;
    }
}

