/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model;

import com.copycatsplus.copycats.config.CCConfigs;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.CopycatModelPart;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.CopycatRenderContext;
import com.copycatsplus.copycats.foundation.copycat.model.forge.CopycatModelCoreImpl;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.utility.BlockUtils;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class CopycatModelCore
implements CopycatModelPart {
    protected static final ModelEntry SUPER = new ModelEntry("super", null, null, EntryType.STATIC);
    public static final String MATERIAL_KEY = "material";
    protected final ModelEntry MATERIAL = new ModelEntry("material", ModelGetter.MATERIAL, this, EntryType.COPYCAT);
    public boolean enhanced = true;
    public boolean colorize = false;

    public void registerModels(List<ModelEntry> entries) {
        entries.add(this.MATERIAL);
    }

    protected final void registerForMultiState(List<ModelEntry> entries, IMultiStateCopycatBlock block, boolean isKinetic) {
        for (String property : block.storageProperties()) {
            this.registerMultiStatePart(entries, property, isKinetic);
        }
    }

    protected final void registerMultiStatePart(List<ModelEntry> entries, String property, boolean isKinetic) {
        entries.add(new ModelEntry(property, (state, mat) -> CopycatModelCore.getModelOf(mat), this, isKinetic ? EntryType.KINETIC_COPYCAT : EntryType.COPYCAT));
    }

    public void prepareForRender() {
        this.enhanced = (Boolean)CCConfigs.client().useEnhancedModels.get();
        this.colorize = (Boolean)CCConfigs.client().colorizeMultiStates.get();
    }

    @Override
    public abstract void emitCopycatQuads(String var1, BlockState var2, CopycatRenderContext var3, BlockState var4);

    public static BakedModel getModelOf(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }

    public static MaterialMapper updatePropertiesIfMatch(Class<?> clazz) {
        return (state, mat) -> {
            if (mat == null) {
                return null;
            }
            if (clazz.isInstance(mat.m_60734_())) {
                return BlockUtils.tryCopyProperties(state, mat);
            }
            return mat;
        };
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static BakedModel createModel(BakedModel original, CopycatModelCore core) {
        void var1_1;
        return CopycatModelCoreImpl.createModel(original, (CopycatModelCore)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static BakedModel createKineticModel(BakedModel original, CopycatModelCore core) {
        void var1_1;
        return CopycatModelCoreImpl.createKineticModel(original, (CopycatModelCore)var1_1);
    }

    public static CopycatModelCore kinetic(final CopycatModelCore ... cores) {
        return new CopycatModelCore(){

            @Override
            public void registerModels(List<ModelEntry> entries) {
                for (CopycatModelCore core : cores) {
                    core.registerModels(entries);
                }
                entries.add(SUPER);
            }

            @Override
            public void emitCopycatQuads(String key, BlockState state, CopycatRenderContext context, BlockState material) {
            }
        };
    }

    @ParametersAreNonnullByDefault
    public record ModelEntry(String key, @Nullable ModelGetter model, @Nullable CopycatModelPart part, MaterialMapper materialMapper, EntryType type) {
        public ModelEntry(String key, @Nullable ModelGetter model, @Nullable CopycatModelPart part, EntryType type) {
            this(key, model, part, MaterialMapper.IDENTITY, type);
        }
    }

    @FunctionalInterface
    public static interface ModelGetter {
        public static final ModelGetter MATERIAL = (state, material) -> CopycatModelCore.getModelOf(material);

        public BakedModel getModel(BlockState var1, BlockState var2);
    }

    public static enum EntryType {
        STATIC(false, false),
        COPYCAT(true, false),
        KINETIC(false, true),
        KINETIC_COPYCAT(true, true);

        private final boolean useCopycatLogic;
        private final boolean onlyWhenVirtual;

        private EntryType(boolean useCopycatLogic, boolean onlyWhenVirtual) {
            this.useCopycatLogic = useCopycatLogic;
            this.onlyWhenVirtual = onlyWhenVirtual;
        }

        public boolean useCopycatLogic() {
            return this.useCopycatLogic;
        }

        public boolean onlyWhenVirtual() {
            return this.onlyWhenVirtual;
        }
    }

    @FunctionalInterface
    public static interface MaterialMapper {
        public static final MaterialMapper IDENTITY = (state, material) -> material;

        public BlockState map(BlockState var1, BlockState var2);
    }

    public static abstract class WithData<T>
    extends CopycatModelCore {
        private final ThreadLocal<T> data = new ThreadLocal();

        public void setData(T data) {
            this.data.set(data);
        }

        public T getData() {
            return this.data.get();
        }
    }
}

