/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.farmersdelight;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import vectorwing.farmersdelight.common.block.CabinetBlock;

public class FarmersDelightModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> cabinets = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "cabinet", this.getModBlock("oak_cabinet"), () -> VanillaWoodTypes.OAK, w -> new CabinetBlock(Utils.copyPropertySafe((Block)w.planks))).requiresChildren(new String[]{"trapdoor", "slab"})).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("cabinets/wooden"), Registries.f_256913_)).defaultRecipe().addTile(this.getModTile("cabinet")).setTabKey(this.modRes("farmersdelight"))).setTabMode(TabAddMode.AFTER_SAME_TYPE)).createPaletteFromPlanks(p -> {
        p.reduceDown();
        if (p.size() < 9) {
            while (p.size() <= 9) {
                p.increaseInner();
            }
        } else {
            while (p.size() >= 9) {
                p.reduce();
            }
        }
    })).addTextureM(this.modRes("block/oak_cabinet_front"), EveryCompat.res("block/fd/oak_cabinet_front_m"))).addTexture(this.modRes("block/oak_cabinet_side"))).addTexture(this.modRes("block/oak_cabinet_top"))).addTexture(this.modRes("block/oak_cabinet_front_open"))).build();

    public FarmersDelightModule(String modId) {
        super(modId, "fd");
        this.addEntry(this.cabinets);
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, handler) -> this.cabinets.items.forEach((woodType, item) -> {
            this.createCuttingRecipe("door", woodType.getBlockOfThis("door"), woodType.planks, (WoodType)woodType, handler, manager);
            this.createCuttingRecipe("hanging_sign", woodType.getBlockOfThis("hanging_sign"), woodType.planks, (WoodType)woodType, handler, manager);
            this.createCuttingRecipe("sign", woodType.getBlockOfThis("sign"), woodType.planks, (WoodType)woodType, handler, manager);
            this.createCuttingRecipe("trapdoor", woodType.getBlockOfThis("trapdoor"), woodType.planks, (WoodType)woodType, handler, manager);
            this.createCuttingRecipe("log", woodType.log, woodType.getBlockOfThis("stripped_log"), (WoodType)woodType, handler, manager);
            this.createCuttingRecipe("wood", woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"), (WoodType)woodType, handler, manager);
        }));
    }

    public void createCuttingRecipe(String recipeType, Block input, Block output, WoodType woodType, ResourceSink handler, ResourceManager manager) {
        if (Objects.nonNull(input) && Objects.nonNull(output)) {
            ResourceLocation recipeLocation = this.modRes("recipes/cutting/oak_" + recipeType + ".json");
            try (InputStream recipeStream = ((Resource)manager.m_213713_(recipeLocation).orElseThrow(() -> new FileNotFoundException(recipeLocation.toString()))).m_215507_();){
                JsonObject recipe = RPUtils.deserializeJson((InputStream)recipeStream);
                JsonObject getItem = recipe.getAsJsonArray("ingredients").get(0).getAsJsonObject();
                getItem.addProperty("item", Utils.getID((Block)input).toString());
                JsonObject getResult = recipe.getAsJsonArray("result").get(0).getAsJsonObject();
                getResult.addProperty("item", Utils.getID((Block)output).toString());
                String path = this.shortenedId() + "/cutting/" + woodType.getAppendableId() + "_" + recipeType;
                handler.addJson(EveryCompat.res(path), (JsonElement)recipe, ResType.RECIPES);
            }
            catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to generate the cutting recipe for {} - {}", (Object)Utils.getID((Block)output), (Object)e);
            }
        }
    }
}

