/*
 * Decompiled with CFR 0.152.
 */
package com.Imphuls3.createcafe.core.registry;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class FluidTypeRegistry {
    public static void register(IEventBus eventBus) {
    }

    public static class TintedFluidType
    extends FluidType {
        private final ResourceLocation stillTexture;
        private final ResourceLocation flowingTexture;
        private final int tintColor;

        public TintedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture, int tintColor) {
            super(properties);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
            this.tintColor = tintColor;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor() {
                    return tintColor;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Color col = new Color(this.getTintColor());
                    return new Vector3f((float)col.getRed() / 255.0f, (float)col.getBlue() / 255.0f, (float)col.getGreen() / 255.0f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    RenderSystem.setShaderFogStart((float)2.0f);
                    RenderSystem.setShaderFogEnd((float)6.0f);
                }
            });
        }
    }

    public static class CaramelS
    extends TintedFluidType {
        public CaramelS(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, new Color(217, 144, 0, 199).getRGB());
        }
    }

    public static class BananaS
    extends TintedFluidType {
        public BananaS(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, new Color(255, 217, 0, 199).getRGB());
        }
    }

    public static class MintS
    extends TintedFluidType {
        public MintS(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, new Color(129, 255, 192, 199).getRGB());
        }
    }

    public static class CoconutS
    extends TintedFluidType {
        public CoconutS(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, new Color(255, 235, 192, 199).getRGB());
        }
    }

    public static class RaspberryS
    extends TintedFluidType {
        public RaspberryS(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, new Color(255, 25, 200, 199).getRGB());
        }
    }

    public static class VanillaS
    extends TintedFluidType {
        public VanillaS(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, new Color(255, 235, 220, 199).getRGB());
        }
    }

    public static class StrawberryS
    extends TintedFluidType {
        public StrawberryS(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, new Color(196, 59, 98, 199).getRGB());
        }
    }

    public static class Coffee
    extends TintedFluidType {
        public Coffee(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -934795501);
        }
    }

    public static class Barberry
    extends TintedFluidType {
        public Barberry(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -928967364);
        }
    }

    public static class Redlove
    extends TintedFluidType {
        public Redlove(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -924692637);
        }
    }

    public static class Citron
    extends TintedFluidType {
        public Citron(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922762496);
        }
    }

    public static class Mandarin
    extends TintedFluidType {
        public Mandarin(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922762730);
        }
    }

    public static class Pomelo
    extends TintedFluidType {
        public Pomelo(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922783924);
        }
    }

    public static class Lavender
    extends TintedFluidType {
        public Lavender(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -924930318);
        }
    }

    public static class Starfruit
    extends TintedFluidType {
        public Starfruit(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922756507);
        }
    }

    public static class Raspberry
    extends TintedFluidType {
        public Raspberry(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922780291);
        }
    }

    public static class Persimmon
    extends TintedFluidType {
        public Persimmon(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -924282522);
        }
    }

    public static class Pomegranate
    extends TintedFluidType {
        public Pomegranate(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -927315877);
        }
    }

    public static class Passionfruit
    extends TintedFluidType {
        public Passionfruit(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922825675);
        }
    }

    public static class Guava
    extends TintedFluidType {
        public Guava(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922778789);
        }
    }

    public static class Papaya
    extends TintedFluidType {
        public Papaya(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922767005);
        }
    }

    public static class Grapefruit
    extends TintedFluidType {
        public Grapefruit(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922779552);
        }
    }

    public static class Grape
    extends TintedFluidType {
        public Grape(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -924158008);
        }
    }

    public static class Gooseberry
    extends TintedFluidType {
        public Gooseberry(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922953402);
        }
    }

    public static class Tamarind
    extends TintedFluidType {
        public Tamarind(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922763905);
        }
    }

    public static class Fig
    extends TintedFluidType {
        public Fig(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -931709851);
        }
    }

    public static class Durian
    extends TintedFluidType {
        public Durian(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -923482510);
        }
    }

    public static class Sweetberry
    extends TintedFluidType {
        public Sweetberry(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -925159864);
        }
    }

    public static class Avocado
    extends TintedFluidType {
        public Avocado(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -929647770);
        }
    }

    public static class Apricot
    extends TintedFluidType {
        public Apricot(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922760300);
        }
    }

    public static class Dragonfruit
    extends TintedFluidType {
        public Dragonfruit(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922804337);
        }
    }

    public static class Coconut
    extends TintedFluidType {
        public Coconut(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922945053);
        }
    }

    public static class Jackfruit
    extends TintedFluidType {
        public Jackfruit(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -923415439);
        }
    }

    public static class Pumpkin
    extends TintedFluidType {
        public Pumpkin(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -923279187);
        }
    }

    public static class Blackberry
    extends TintedFluidType {
        public Blackberry(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -930655612);
        }
    }

    public static class Apple
    extends TintedFluidType {
        public Apple(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922948745);
        }
    }

    public static class Aloe
    extends TintedFluidType {
        public Aloe(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -929505710);
        }
    }

    public static class Plum
    extends TintedFluidType {
        public Plum(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922765067);
        }
    }

    public static class Cherry
    extends TintedFluidType {
        public Cherry(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -926464930);
        }
    }

    public static class Yucca
    extends TintedFluidType {
        public Yucca(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -926354850);
        }
    }

    public static class Banana
    extends TintedFluidType {
        public Banana(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922753122);
        }
    }

    public static class Pineapple
    extends TintedFluidType {
        public Pineapple(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922757294);
        }
    }

    public static class Peach
    extends TintedFluidType {
        public Peach(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -923942241);
        }
    }

    public static class Orange
    extends TintedFluidType {
        public Orange(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -924935117);
        }
    }

    public static class Vanilla
    extends TintedFluidType {
        public Vanilla(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -923932968);
        }
    }

    public static class Blueberry
    extends TintedFluidType {
        public Blueberry(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -929067777);
        }
    }

    public static class Strawberry
    extends TintedFluidType {
        public Strawberry(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922769736);
        }
    }

    public static class Watermelon
    extends TintedFluidType {
        public Watermelon(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -927450282);
        }
    }

    public static class Lemon
    extends TintedFluidType {
        public Lemon(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922753467);
        }
    }

    public static class Blood
    extends TintedFluidType {
        public Blood(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922996733);
        }
    }

    public static class Mana
    extends TintedFluidType {
        public Mana(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -937958145);
        }
    }

    public static class Kiwi
    extends TintedFluidType {
        public Kiwi(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -929760112);
        }
    }

    public static class Lychee
    extends TintedFluidType {
        public Lychee(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922772842);
        }
    }

    public static class Lime
    extends TintedFluidType {
        public Lime(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -927727834);
        }
    }

    public static class Mango
    extends TintedFluidType {
        public Mango(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922959811);
        }
    }

    public static class Oreo
    extends TintedFluidType {
        public Oreo(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -924919085);
        }
    }

    public static class Filling
    extends TintedFluidType {
        public Filling(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -923931155);
        }
    }

    public static class MeltedSugar
    extends TintedFluidType {
        public MeltedSugar(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture, -922748960);
        }
    }
}

