/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import com.petrolpark.item.decay.IDecayingItem;
import com.petrolpark.util.NBTHelper;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemHelper {
    public static boolean equalIgnoringTags(ItemStack stack1, ItemStack stack2, String ... ignoredTagKeys) {
        ItemStack trueStack2;
        ItemStack trueStack1 = IDecayingItem.checkDecay(stack1);
        if (!trueStack1.m_150930_((trueStack2 = IDecayingItem.checkDecay(stack2)).m_41720_())) {
            return false;
        }
        if (trueStack1.m_41619_()) {
            return trueStack2.m_41619_();
        }
        return NBTHelper.equalIgnoring(trueStack1.m_41783_(), trueStack2.m_41783_(), ignoredTagKeys) && trueStack1.areCapsCompatible((CapabilityProvider)trueStack2);
    }

    public static void pop(Level level, Vec3 position, ItemStack stack) {
        if (level.m_5776_()) {
            return;
        }
        ItemEntity entity = new ItemEntity(level, position.f_82479_, position.f_82480_, position.f_82481_, stack);
        entity.m_32060_();
        level.m_7967_((Entity)entity);
    }

    public static int removeItems(IItemHandler inv, Predicate<ItemStack> test, int maxCount) {
        int removed = 0;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            if (!test.test(inv.getStackInSlot(slot))) continue;
            removed += inv.extractItem(slot, maxCount - removed, false).m_41613_();
        }
        return removed;
    }

    public static void give(Entity entity, Stream<ItemStack> stacks) {
        if (entity instanceof InventoryCarrier) {
            InventoryCarrier hasInv = (InventoryCarrier)entity;
            stacks.forEach(stack -> entity.m_19983_(ItemHandlerHelper.insertItemStacked((IItemHandler)new InvWrapper((Container)hasInv.m_35311_()), (ItemStack)stack, (boolean)false)));
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            stacks.forEach(arg_0 -> ((Inventory)player.m_150109_()).m_150079_(arg_0));
        } else {
            stacks.forEach(arg_0 -> ((Entity)entity).m_19983_(arg_0));
        }
    }
}

