/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.team.scoreboard;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.network.packet.S2CPacket;
import com.petrolpark.team.data.ITeamDataType;
import com.petrolpark.team.scoreboard.ScoreboardTeam;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ScoreboardTeamDataChangedPacket
extends S2CPacket {
    private final String teamName;
    private final ITeamDataType<?> dataType;
    private final CompoundTag tag;

    public <T> ScoreboardTeamDataChangedPacket(Level level, ScoreboardTeam team, ITeamDataType<T> dataType) {
        this(level, team.team.m_5758_(), dataType, team.getTeamData(dataType));
    }

    public <T> ScoreboardTeamDataChangedPacket(Level level, String teamName, ITeamDataType<T> dataType, T data) {
        this.teamName = teamName;
        this.dataType = dataType;
        this.tag = dataType.save(level, data);
    }

    public ScoreboardTeamDataChangedPacket(FriendlyByteBuf buffer) {
        this.teamName = buffer.m_130277_();
        this.dataType = (ITeamDataType)buffer.readRegistryIdUnsafe(PetrolparkRegistries.getRegistry(PetrolparkRegistries.Keys.TEAM_DATA_TYPE));
        this.tag = buffer.m_130261_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.teamName);
        buffer.writeRegistryIdUnsafe(PetrolparkRegistries.getRegistry(PetrolparkRegistries.Keys.TEAM_DATA_TYPE), this.dataType);
        buffer.m_130079_(this.tag);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        Minecraft mc = Minecraft.m_91087_();
        supplier.get().enqueueWork(() -> Petrolpark.SCOREBOARD_TEAMS.setData((Level)mc.f_91073_, this.teamName, this.dataType, this.tag));
        return true;
    }
}

