/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.team;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.team.ITeam;
import com.petrolpark.team.data.ITeamDataType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public abstract class AbstractTeam<T extends ITeam<? super T>>
implements ITeam<T> {
    protected final Map<ITeamDataType<?>, Object> data = new HashMap();

    @Override
    public final boolean isNone() {
        return false;
    }

    @Override
    public <DATA> DATA getTeamData(ITeamDataType<? super DATA> dataType) {
        return (DATA)this.data.computeIfAbsent(dataType, ITeamDataType::getBlankInstance);
    }

    public Stream<ITeamDataType<?>> streamNonBlankTeamData() {
        return this.data.keySet().stream().dropWhile(this::isBlank);
    }

    public <DT> boolean isBlank(ITeamDataType<DT> dataType) {
        return dataType.isBlank(this.getTeamData(dataType));
    }

    public CompoundTag saveTeamData(Level level) {
        CompoundTag tag = new CompoundTag();
        for (ITeamDataType<?> dataType : this.data.keySet()) {
            this.saveTeamData(level, dataType, tag);
        }
        return tag;
    }

    protected <DT> void saveTeamData(Level level, ITeamDataType<DT> dataType, CompoundTag tag) {
        DT data = this.getTeamData(dataType);
        if (dataType.isBlank(data)) {
            return;
        }
        tag.m_128365_(PetrolparkRegistries.getRegistry(PetrolparkRegistries.Keys.TEAM_DATA_TYPE).getKey(dataType).toString(), (Tag)dataType.save(level, data));
    }

    public void loadTeamData(Level level, CompoundTag tag) {
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 10)) continue;
            ITeamDataType dataType = (ITeamDataType)PetrolparkRegistries.getRegistry(PetrolparkRegistries.Keys.TEAM_DATA_TYPE).getValue(new ResourceLocation(key));
            if (dataType != null) {
                this.loadTeamData(level, tag.m_128469_(key), dataType);
                continue;
            }
            Petrolpark.LOGGER.warn("Unknown Team Data Type: " + key);
        }
    }

    public <DT> void loadTeamData(Level level, CompoundTag dataTag, ITeamDataType<DT> dataType) {
        this.data.put(dataType, dataType.load(level, dataTag));
    }

    public void copyTeamData(Level level, AbstractTeam<?> other) {
        this.copyTeamData(level, other, td -> true);
    }

    public void copyTeamData(Level level, AbstractTeam<?> other, Predicate<ITeamDataType<?>> exclude) {
        this.data.clear();
        for (ITeamDataType<?> dataType : other.data.keySet()) {
            if (exclude.test(dataType)) continue;
            this.data.put(dataType, other.getTeamData(dataType));
            this.setChanged(level, dataType);
        }
    }
}

