/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.network;

import com.petrolpark.Petrolpark;
import com.petrolpark.network.packet.C2SPacket;
import com.petrolpark.network.packet.S2CPacket;
import com.petrolpark.team.packet.BindTeamBlockPacket;
import com.petrolpark.team.packet.BindTeamItemPacket;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PetrolparkMessages {
    private static SimpleChannel INSTANCE;
    private static int packetID;

    private static int id() {
        return packetID++;
    }

    public static void register() {
        INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)Petrolpark.asResource("messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        PetrolparkMessages.addC2SPacket(BindTeamBlockPacket.class, BindTeamBlockPacket::new);
        PetrolparkMessages.addC2SPacket(BindTeamItemPacket.class, BindTeamItemPacket::new);
    }

    public static <T extends S2CPacket> void addS2CPacket(Class<T> clazz, Function<FriendlyByteBuf, T> decoder) {
        INSTANCE.messageBuilder(clazz, PetrolparkMessages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(decoder).encoder(S2CPacket::toBytes).consumerMainThread(S2CPacket::handle).add();
    }

    public static <T extends C2SPacket> void addC2SPacket(Class<T> clazz, Function<FriendlyByteBuf, T> decoder) {
        INSTANCE.messageBuilder(clazz, PetrolparkMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(decoder).encoder(C2SPacket::toBytes).consumerMainThread(C2SPacket::handle).add();
    }

    public static void sendToServer(C2SPacket message) {
        INSTANCE.sendToServer((Object)message);
    }

    public static void sendToClient(S2CPacket message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public static void sendToAllClients(S2CPacket message) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    static {
        packetID = 0;
    }
}

