/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.item.decay;

import com.petrolpark.Petrolpark;
import com.petrolpark.contamination.ItemContamination;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IDecayingItem {
    public ItemStack getDecayProduct(ItemStack var1);

    public long getLifetime(ItemStack var1);

    default public boolean areDecayTimesCombineable(ItemStack stack1, ItemStack stack2) {
        return true;
    }

    default public String getDecayTimeTranslationKey(ItemStack stack) {
        return "item.petrolpark.decaying_item.remaining";
    }

    public static ItemStack checkDecay(ItemStack stack) {
        if (stack.m_41619_()) {
            return stack;
        }
        Item item = stack.m_41720_();
        if (item instanceof IDecayingItem) {
            long timeDead;
            IDecayingItem item2 = (IDecayingItem)item;
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128425_("CreationTime", 4) && (timeDead = -IDecayingItem.getRemainingTime(item2, stack, tag)) >= 0L) {
                ItemStack product = item2.getDecayProduct(stack);
                product.m_41764_(stack.m_41613_());
                ItemContamination.get(product).contaminateAll(ItemContamination.get(stack).streamAllContaminants());
                IDecayingItem.startDecay(product, timeDead);
                return IDecayingItem.checkDecay(product);
            }
        }
        return stack;
    }

    public static long getRemainingTime(IDecayingItem decayingItem, ItemStack decayingItemStack, CompoundTag decayingItemTag) {
        return decayingItem.getLifetime(decayingItemStack) + decayingItemTag.m_128454_("CreationTime") - Petrolpark.DECAYING_ITEM_HANDLER.get().getGameTime();
    }

    public static void startDecay(ItemStack stack) {
        IDecayingItem.startDecay(stack, 0L);
    }

    public static void startDecay(ItemStack stack, long timeElapsed) {
        CompoundTag tag;
        if (stack.m_41720_() instanceof IDecayingItem && !(tag = stack.m_41784_()).m_128425_("CreationTime", 4)) {
            tag.m_128356_("CreationTime", Petrolpark.DECAYING_ITEM_HANDLER.get().getGameTime() - timeElapsed);
        }
    }

    public static void extendLifetime(ItemStack decayingItemStack, int additionalLifetime) {
        Item item = decayingItemStack.m_41720_();
        if (item instanceof IDecayingItem) {
            IDecayingItem item2 = (IDecayingItem)item;
            CompoundTag tag = decayingItemStack.m_41784_();
            long remainingTime = IDecayingItem.getRemainingTime(item2, decayingItemStack, tag);
            long newLifetime = Math.max(0L, (long)additionalLifetime + remainingTime);
            tag.m_128356_("CreationTime", Petrolpark.DECAYING_ITEM_HANDLER.get().getGameTime() + newLifetime - item2.getLifetime(decayingItemStack));
        }
    }
}

