/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data.reward.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.petrolpark.data.reward.IReward;
import com.petrolpark.data.reward.RewardGeneratorTypes;
import com.petrolpark.data.reward.generator.IRewardGenerator;
import com.petrolpark.data.reward.generator.RewardGeneratorType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;

public class CombinedRewardGenerator
implements IRewardGenerator {
    protected final IRewardGenerator[] values;

    public CombinedRewardGenerator(IRewardGenerator[] children) {
        this.values = children;
    }

    @Override
    public List<IReward> generate(LootContext context) {
        return Stream.of(this.values).map(rg -> rg.generate(context)).flatMap(Collection::stream).toList();
    }

    @Override
    public RewardGeneratorType getType() {
        return (RewardGeneratorType)((Object)RewardGeneratorTypes.COMBINED.get());
    }

    public Set<LootContextParam<?>> m_6231_() {
        return Stream.of(this.values).map(LootContextUser::m_6231_).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<CombinedRewardGenerator> {
        public void serialize(JsonObject json, CombinedRewardGenerator value, JsonSerializationContext serializationContext) {
            JsonArray array = new JsonArray(value.values.length);
            for (IRewardGenerator child : value.values) {
                array.add(serializationContext.serialize((Object)child, IRewardGenerator.class));
            }
            json.add("values", (JsonElement)array);
        }

        public CombinedRewardGenerator deserialize(JsonObject json, JsonDeserializationContext serializationContext) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"values");
            IRewardGenerator[] rewardGenerators = new IRewardGenerator[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                rewardGenerators[i] = (IRewardGenerator)GsonHelper.m_13836_((JsonObject)json, (String)"reward generator", (JsonDeserializationContext)serializationContext, IRewardGenerator.class);
            }
            return new CombinedRewardGenerator(rewardGenerators);
        }
    }
}

