/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data.advancement;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SimpleAdvancementTrigger
implements CriterionTrigger<Instance> {
    private final ResourceLocation id;
    protected final Map<PlayerAdvancements, Set<CriterionTrigger.Listener<Instance>>> listeners = Maps.newHashMap();

    public SimpleAdvancementTrigger(ResourceLocation id) {
        this.id = id;
    }

    public Instance createInstance(JsonObject json, DeserializationContext context) {
        return new Instance();
    }

    public Instance instance() {
        return new Instance();
    }

    public void m_6467_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listener) {
        this.listeners.computeIfAbsent(playerAdvancementsIn, k -> new HashSet()).add(listener);
    }

    public void m_6468_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listener) {
        Set<CriterionTrigger.Listener<Instance>> playerListeners = this.listeners.get(playerAdvancementsIn);
        if (playerListeners != null) {
            playerListeners.remove(listener);
            if (playerListeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void m_5656_(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public ResourceLocation m_7295_() {
        return this.id;
    }

    public void trigger(ServerPlayer player) {
        PlayerAdvancements playerAdvancements = player.m_8960_();
        Set<CriterionTrigger.Listener<Instance>> playerListeners = this.listeners.get(playerAdvancements);
        if (playerListeners != null) {
            playerListeners.forEach(listener -> listener.m_13686_(playerAdvancements));
        }
    }

    public class Instance
    extends AbstractCriterionTriggerInstance {
        public Instance() {
            super(SimpleAdvancementTrigger.this.m_7295_(), ContextAwarePredicate.f_285567_);
        }
    }
}

