/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public interface IEntityTarget {
    public static final Map<ResourceLocation, LootContextParam<? extends Entity>> CUSTOM = new HashMap<ResourceLocation, LootContextParam<? extends Entity>>();

    public static void register(LootContextParam<? extends Entity> lootContextParam) {
        CUSTOM.put(lootContextParam.m_81284_(), lootContextParam);
    }

    public Entity get(LootContext var1);

    public String name();

    public LootContextParam<? extends Entity> getReferencedParam();

    public static IEntityTarget getByName(String name) {
        try {
            LootContext.EntityTarget builtInTarget = LootContext.EntityTarget.m_79006_((String)name);
            return Targets.TARGETS.computeIfAbsent(name, s -> new BuiltIn(builtInTarget));
        }
        catch (IllegalArgumentException e) {
            LootContextParam<? extends Entity> param = CUSTOM.get(new ResourceLocation(name));
            if (param != null) {
                return Targets.TARGETS.putIfAbsent(name, new Custom(param));
            }
            throw new IllegalArgumentException("Unknown contextual Entity: " + name);
        }
    }

    public static class Targets {
        private static final Map<String, IEntityTarget> TARGETS = new HashMap<String, IEntityTarget>();

        static {
            IEntityTarget.register((LootContextParam<? extends Entity>)LootContextParams.f_81455_);
            IEntityTarget.register((LootContextParam<? extends Entity>)LootContextParams.f_81458_);
            IEntityTarget.register((LootContextParam<? extends Entity>)LootContextParams.f_81456_);
        }
    }

    public static class Custom
    implements IEntityTarget {
        public final LootContextParam<? extends Entity> param;

        public Custom(LootContextParam<? extends Entity> param) {
            this.param = param;
        }

        @Override
        public Entity get(LootContext context) {
            return (Entity)context.m_78953_(this.param);
        }

        @Override
        public String name() {
            return this.param.m_81284_().toString();
        }

        @Override
        public LootContextParam<? extends Entity> getReferencedParam() {
            return this.param;
        }
    }

    public static class BuiltIn
    implements IEntityTarget {
        public final LootContext.EntityTarget target;

        public BuiltIn(LootContext.EntityTarget target) {
            this.target = target;
        }

        @Override
        public Entity get(LootContext context) {
            return (Entity)context.m_78953_(this.target.m_79003_());
        }

        @Override
        public String name() {
            return this.target.getName();
        }

        @Override
        public LootContextParam<? extends Entity> getReferencedParam() {
            return this.target.m_79003_();
        }
    }
}

