/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.item;

import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class QueueItemHandler
implements IItemHandler,
INBTSerializable<ListTag> {
    protected final Queue<ItemStack> stacks = new LinkedList<ItemStack>();

    public boolean isEmpty() {
        this.skimEmptyStacks();
        return this.stacks.isEmpty();
    }

    public final int getSlots() {
        return 1;
    }

    public void skimEmptyStacks() {
        while (this.stacks.peek() != null && this.stacks.peek().m_41619_() && !this.stacks.isEmpty()) {
            this.stacks.poll();
        }
    }

    public ItemStack peekStack() {
        this.skimEmptyStacks();
        return Optional.ofNullable(this.stacks.peek()).orElse(ItemStack.f_41583_);
    }

    public ItemStack pollStack() {
        this.skimEmptyStacks();
        ItemStack stack = this.stacks.poll();
        if (stack == null) {
            return ItemStack.f_41583_;
        }
        if (!stack.m_41619_()) {
            this.onContentsChanged();
        }
        return stack;
    }

    public ItemStack add(ItemStack stack) {
        if (stack.m_41619_() || !this.isItemValid(stack)) {
            return stack;
        }
        ItemStack toInsert = stack.m_41777_();
        for (ItemStack existing : this.stacks) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)existing, (ItemStack)toInsert)) continue;
            int added = Math.min(toInsert.m_41613_(), Math.min(existing.m_41741_(), this.getStackSizeLimit()) - existing.m_41613_());
            existing.m_41769_(added);
            toInsert.m_41774_(added);
        }
        while (!toInsert.m_41619_()) {
            int added = Math.min(toInsert.m_41613_(), this.getStackSizeLimit());
            this.stacks.add(toInsert.m_255036_(added));
            toInsert.m_41774_(added);
        }
        this.onContentsChanged();
        return ItemStack.f_41583_;
    }

    @NotNull
    public final ItemStack getStackInSlot(int slot) {
        return this.peekStack();
    }

    @NotNull
    public final ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (simulate) {
            return this.isItemValid(stack) ? ItemStack.f_41583_ : stack;
        }
        return this.add(stack);
    }

    @NotNull
    public final ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.peekStack();
        if (amount >= stack.m_41613_()) {
            return simulate ? stack : this.pollStack();
        }
        ItemStack extracted = stack.m_255036_(amount);
        if (!simulate) {
            stack.m_41774_(amount);
            this.onContentsChanged();
        }
        return extracted;
    }

    public final int getSlotLimit(int slot) {
        return this.getStackSizeLimit();
    }

    public int getStackSizeLimit() {
        return Integer.MAX_VALUE;
    }

    public final boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isItemValid(stack);
    }

    public boolean isItemValid(ItemStack stack) {
        return true;
    }

    public ListTag serializeNBT() {
        ListTag listTag = new ListTag();
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            listTag.add((Object)itemTag);
        }
        return listTag;
    }

    public void deserializeNBT(ListTag nbt) {
        this.stacks.clear();
        for (int i = 0; i < nbt.size(); ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt.m_128728_(i));
            if (stack.m_41619_()) continue;
            this.stacks.add(stack);
        }
        this.onLoad();
    }

    protected void onContentsChanged() {
    }

    protected void onLoad() {
    }
}

