/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.contamination;

import com.petrolpark.contamination.Contaminable;
import com.petrolpark.contamination.Contaminables;
import com.petrolpark.contamination.Contamination;
import com.petrolpark.contamination.IContamination;
import com.petrolpark.contamination.IncontaminableContamination;
import com.petrolpark.fluid.FluidMixer;
import com.petrolpark.util.FluidHelper;
import java.util.stream.Stream;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidContamination
extends Contamination<Fluid, FluidStack> {
    public static final String TAG_KEY = "Contamination";
    public static final FluidMixer.IFluidMixer MIXER = new FluidMixer.IFluidMixer(){

        @Override
        public int getMix2Priority(FluidStack fluidStack1, FluidStack fluidStack2) {
            return FluidHelper.equalIgnoringTags(fluidStack1, fluidStack2, FluidContamination.TAG_KEY) ? 1 : -1;
        }

        @Override
        public int getMixPriority(FluidStack ... fluidStacks) {
            FluidStack fluidStack0 = fluidStacks[0];
            for (int i = 1; i < fluidStacks.length; ++i) {
                if (FluidHelper.equalIgnoringTags(fluidStack0, fluidStacks[i], FluidContamination.TAG_KEY)) continue;
                return -1;
            }
            return 1;
        }

        @Override
        public FluidStack mix2(FluidStack fluidStack1, FluidStack fluidStack2) {
            FluidStack result = fluidStack1.copy();
            result.grow(fluidStack2.getAmount());
            return result;
        }

        @Override
        public FluidStack mix(FluidStack ... fluidStacks) {
            FluidStack result = fluidStacks[0];
            for (int i = 1; i < fluidStacks.length; ++i) {
                result.grow(fluidStacks[i].getAmount());
            }
            return result;
        }

        @Override
        public void afterMix(FluidStack result, FluidStack ... fluidStacks) {
            FluidContamination.perpetuate(Stream.of(fluidStacks), result);
        }
    };

    public static IContamination<?, ?> get(FluidStack stack) {
        if (!Contaminables.FLUID.isContaminableStack(stack)) {
            return new FluidContamination(stack);
        }
        return IncontaminableContamination.INSTANCE;
    }

    public static void perpetuate(Stream<FluidStack> inputs, FluidStack output) {
        FluidContamination.perpetuate(inputs, Stream.of(output));
    }

    public static void perpetuate(Stream<FluidStack> inputs, Stream<FluidStack> outputs) {
        IContamination.perpetuate(inputs, outputs, FluidContamination::get);
    }

    protected FluidContamination(FluidStack stack) {
        super(stack);
        if (stack.getTag() != null && stack.getTag().m_128425_(TAG_KEY, 9)) {
            this.readNBT(stack.getTag().m_128437_(TAG_KEY, 8));
        }
    }

    @Override
    public Contaminable<Fluid, FluidStack> getContaminable() {
        return Contaminables.FLUID;
    }

    @Override
    public Fluid getType() {
        return ((FluidStack)this.stack).getFluid();
    }

    @Override
    public double getAmount() {
        return ((FluidStack)this.stack).getAmount();
    }

    @Override
    public void save() {
        ((FluidStack)this.stack).removeChildTag(TAG_KEY);
        if (!this.orphanContaminants.isEmpty()) {
            ((FluidStack)this.stack).getOrCreateTag().m_128365_(TAG_KEY, (Tag)this.writeNBT());
        }
    }
}

