/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.contamination;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.contamination.Contaminant;
import com.petrolpark.contamination.ItemContamination;
import com.petrolpark.network.GsonSerializableCodecs;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ContaminateGlobalLootModifier
extends LootModifier {
    public static final Codec<ContaminateGlobalLootModifier> CODEC = RecordCodecBuilder.create(instance -> ContaminateGlobalLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ResourceLocation.f_135803_.fieldOf("contaminant").forGetter(cglm -> cglm.contaminantLocation)).and((App)GsonSerializableCodecs.NUMBER_PROVIDER.fieldOf("chance").forGetter(ContaminateGlobalLootModifier::getChanceProvider)).apply((Applicative)instance, ContaminateGlobalLootModifier::new));
    private final ResourceLocation contaminantLocation;
    protected Contaminant contaminant;
    protected final NumberProvider chanceProvider;

    protected ContaminateGlobalLootModifier(LootItemCondition[] conditionsIn, ResourceLocation contaminantLocation, NumberProvider chanceProvider) {
        super(conditionsIn);
        this.contaminantLocation = contaminantLocation;
        this.chanceProvider = chanceProvider;
    }

    public NumberProvider getChanceProvider() {
        return this.chanceProvider;
    }

    public Contaminant getContaminant() {
        if (this.contaminant == null) {
            this.contaminant = Contaminant.get(this.contaminantLocation);
        }
        return this.contaminant;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.getContaminant() == null) {
            throw new JsonSyntaxException("Unknown Contaminant in contaminate Global Loot Modifier: " + this.contaminantLocation.toString());
        }
        float chance = this.chanceProvider.m_142688_(context);
        if (chance <= 0.0f) {
            return generatedLoot;
        }
        for (ItemStack stack : generatedLoot) {
            if (context.m_230907_().m_188501_() > chance) continue;
            ItemContamination.get(stack).contaminate(this.getContaminant());
        }
        return generatedLoot;
    }
}

