/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.tube;

import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.core.tube.ITubeBlock;
import com.petrolpark.compat.create.core.tube.TubeSpline;
import com.petrolpark.network.packet.C2SPacket;
import com.petrolpark.util.ItemHelper;
import com.petrolpark.util.NetworkHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

@RequiresCreate
public class BuildTubePacket
extends C2SPacket {
    public final Block block;
    public final ITubeBlock tubeBlock;
    public final TubeSpline spline;

    public BuildTubePacket(ITubeBlock tubeBlock, TubeSpline spline) {
        Block block;
        this.tubeBlock = tubeBlock;
        if (!(tubeBlock instanceof Block)) {
            throw new IllegalArgumentException("That is not a block");
        }
        this.block = block = (Block)tubeBlock;
        this.spline = spline;
    }

    public BuildTubePacket(FriendlyByteBuf buffer) {
        double maxAngle;
        double segmentRadius;
        double segmentLength;
        Block block = this.block = (Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS);
        if (block instanceof ITubeBlock) {
            ITubeBlock tubeBlock;
            this.tubeBlock = tubeBlock = (ITubeBlock)block;
            segmentLength = tubeBlock.getTubeSegmentLength();
            segmentRadius = tubeBlock.getTubeSegmentRadius();
            maxAngle = tubeBlock.getTubeMaxAngle();
        } else {
            this.tubeBlock = null;
            segmentLength = 1.0;
            segmentRadius = 1.0;
            maxAngle = 0.0;
        }
        this.spline = new TubeSpline(NetworkHelper.readBlockFace(buffer), NetworkHelper.readBlockFace(buffer), NetworkHelper.readList(buffer, NetworkHelper::readVec3), maxAngle, segmentLength, segmentRadius);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (Object)this.block);
        NetworkHelper.writeBlockFace(buffer, this.spline.start);
        NetworkHelper.writeBlockFace(buffer, this.spline.end);
        NetworkHelper.writeList(buffer, this.spline.getMiddleControlPoints(), NetworkHelper::writeVec3);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        ServerPlayer player = context.getSender();
        context.enqueueWork(() -> {
            if (this.tubeBlock == null) {
                return;
            }
            this.spline.validate(player.m_9236_(), (Player)player, this.block.m_5456_(), this.tubeBlock);
            if (this.spline.getResult().success) {
                if (!player.m_150110_().f_35937_) {
                    ItemHelper.removeItems((IItemHandler)new InvWrapper((Container)player.m_150109_()), s -> s.m_150930_(this.block.m_5456_()), this.tubeBlock.getItemsForTubeLength(this.spline.getLength()));
                }
                this.tubeBlock.connectTube(player.m_9236_(), this.spline);
            }
        });
        return true;
    }
}

