/*
 * Decompiled with CFR 0.152.
 */
package net.lulaboludo.createornithopterglider.item.custom;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.lulaboludo.createornithopterglider.item.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class OrnithopterGliderItem
extends ElytraItem
implements ICurioItem {
    public OrnithopterGliderItem(Item.Properties properties) {
        super(properties);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        int ticks = livingEntity.m_21256_();
        if (ticks > 0 && livingEntity.m_21255_()) {
            stack.elytraFlightTick(livingEntity, ticks);
        }
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, ItemStack repairCandidate) {
        if (repairCandidate.m_41720_() instanceof Item) {
            Item expectedWingMesh = this.getCorrespondingWingMesh(toRepair.m_41720_());
            return repairCandidate.m_150930_(expectedWingMesh);
        }
        return false;
    }

    public ResourceLocation getEntityTexture(ItemStack stack) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)this);
        if (id == null) {
            id = new ResourceLocation("createornithopterglider", "ornithopterglider");
        }
        return new ResourceLocation("createornithopterglider", "textures/entity/" + id.m_135815_() + ".png");
    }

    public static boolean isFlying(Player player) {
        if (player == null) {
            return false;
        }
        if (!player.m_21255_()) {
            return false;
        }
        ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
        if (chestStack.m_41720_() instanceof OrnithopterGliderItem) {
            return true;
        }
        Optional maybeCurios = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        if (maybeCurios.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)maybeCurios.get();
            return handler.isEquipped(stack -> stack.m_41720_() instanceof OrnithopterGliderItem);
        }
        return false;
    }

    private Item getCorrespondingWingMesh(Item glider) {
        for (Map.Entry<DyeColor, RegistryObject<Item>> entry : ModItems.ORNITHOPTER_ITEMS.entrySet()) {
            if (entry.getValue().get() != glider) continue;
            DyeColor color = entry.getKey();
            return (Item)ModItems.WING_MESHES.get(color).get();
        }
        throw new IllegalArgumentException("Glider n\u00e3o corresponde a nenhuma wing mesh conhecida: " + String.valueOf(glider));
    }
}

